/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.signature;

import android.content.Context;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.signature.ApplicationVersionSignature;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public final class AndroidResourceSignature
implements Key {
    private final int nightMode;
    private final Key applicationVersion;

    @NonNull
    public static Key obtain(@NonNull Context context) {
        Key signature = ApplicationVersionSignature.obtain(context);
        int nightMode = context.getResources().getConfiguration().uiMode & 0x30;
        return new AndroidResourceSignature(nightMode, signature);
    }

    private AndroidResourceSignature(int nightMode, Key applicationVersion) {
        this.nightMode = nightMode;
        this.applicationVersion = applicationVersion;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof AndroidResourceSignature) {
            AndroidResourceSignature that = (AndroidResourceSignature)o;
            return this.nightMode == that.nightMode && this.applicationVersion.equals(that.applicationVersion);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Util.hashCode(this.applicationVersion, this.nightMode);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        this.applicationVersion.updateDiskCacheKey(messageDigest);
        byte[] nightModeData = ByteBuffer.allocate(4).putInt(this.nightMode).array();
        messageDigest.update(nightModeData);
    }
}

