/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.resource.bitmap;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapTransformation;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import com.bumptech.glide.util.Util;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public final class GranularRoundedCorners
extends BitmapTransformation {
    private static final String ID = "com.bumptech.glide.load.resource.bitmap.GranularRoundedCorners";
    private static final byte[] ID_BYTES = "com.bumptech.glide.load.resource.bitmap.GranularRoundedCorners".getBytes(CHARSET);
    private final float topLeft;
    private final float topRight;
    private final float bottomRight;
    private final float bottomLeft;

    public GranularRoundedCorners(float topLeft, float topRight, float bottomRight, float bottomLeft) {
        this.topLeft = topLeft;
        this.topRight = topRight;
        this.bottomRight = bottomRight;
        this.bottomLeft = bottomLeft;
    }

    @Override
    protected Bitmap transform(@NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        return TransformationUtils.roundedCorners(pool, toTransform, this.topLeft, this.topRight, this.bottomRight, this.bottomLeft);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof GranularRoundedCorners) {
            GranularRoundedCorners other = (GranularRoundedCorners)o;
            return this.topLeft == other.topLeft && this.topRight == other.topRight && this.bottomRight == other.bottomRight && this.bottomLeft == other.bottomLeft;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hashCode = Util.hashCode(ID.hashCode(), Util.hashCode(this.topLeft));
        hashCode = Util.hashCode(this.topRight, hashCode);
        hashCode = Util.hashCode(this.bottomRight, hashCode);
        return Util.hashCode(this.bottomLeft, hashCode);
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update(ID_BYTES);
        byte[] radiusData = ByteBuffer.allocate(16).putFloat(this.topLeft).putFloat(this.topRight).putFloat(this.bottomRight).putFloat(this.bottomLeft).array();
        messageDigest.update(radiusData);
    }
}

