/*
 * Decompiled with CFR 0.152.
 */
package androidx.tracing;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.tracing.TraceApi18Impl;
import androidx.tracing.TraceApi29Impl;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Trace {
    static final String TAG = "Trace";
    private static long sTraceTagApp;
    private static Method sIsTagEnabledMethod;
    private static Method sAsyncTraceBeginMethod;
    private static Method sAsyncTraceEndMethod;
    private static Method sTraceCounterMethod;

    @SuppressLint(value={"NewApi"})
    public static boolean isEnabled() {
        try {
            if (sIsTagEnabledMethod == null) {
                return android.os.Trace.isEnabled();
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        return Trace.isEnabledFallback();
    }

    public static void beginSection(@NonNull String label) {
        if (Build.VERSION.SDK_INT >= 18) {
            TraceApi18Impl.beginSection(label);
        }
    }

    public static void endSection() {
        if (Build.VERSION.SDK_INT >= 18) {
            TraceApi18Impl.endSection();
        }
    }

    @SuppressLint(value={"NewApi"})
    public static void beginAsyncSection(@NonNull String methodName, int cookie) {
        try {
            if (sAsyncTraceBeginMethod == null) {
                TraceApi29Impl.beginAsyncSection(methodName, cookie);
                return;
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        Trace.beginAsyncSectionFallback(methodName, cookie);
    }

    @SuppressLint(value={"NewApi"})
    public static void endAsyncSection(@NonNull String methodName, int cookie) {
        try {
            if (sAsyncTraceEndMethod == null) {
                TraceApi29Impl.endAsyncSection(methodName, cookie);
                return;
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        Trace.endAsyncSectionFallback(methodName, cookie);
    }

    @SuppressLint(value={"NewApi"})
    public static void setCounter(@NonNull String counterName, int counterValue) {
        try {
            if (sTraceCounterMethod == null) {
                TraceApi29Impl.setCounter(counterName, counterValue);
                return;
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        Trace.setCounterFallback(counterName, counterValue);
    }

    private static boolean isEnabledFallback() {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                if (sIsTagEnabledMethod == null) {
                    Field traceTagAppField = android.os.Trace.class.getField("TRACE_TAG_APP");
                    sTraceTagApp = traceTagAppField.getLong(null);
                    sIsTagEnabledMethod = android.os.Trace.class.getMethod("isTagEnabled", Long.TYPE);
                }
                return (Boolean)sIsTagEnabledMethod.invoke(null, sTraceTagApp);
            }
            catch (Exception exception) {
                Trace.handleException("isTagEnabled", exception);
            }
        }
        return false;
    }

    private static void beginAsyncSectionFallback(@NonNull String methodName, int cookie) {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                if (sAsyncTraceBeginMethod == null) {
                    sAsyncTraceBeginMethod = android.os.Trace.class.getMethod("asyncTraceBegin", Long.TYPE, String.class, Integer.TYPE);
                }
                sAsyncTraceBeginMethod.invoke(null, sTraceTagApp, methodName, cookie);
            }
            catch (Exception exception) {
                Trace.handleException("asyncTraceBegin", exception);
            }
        }
    }

    private static void endAsyncSectionFallback(@NonNull String methodName, int cookie) {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                if (sAsyncTraceEndMethod == null) {
                    sAsyncTraceEndMethod = android.os.Trace.class.getMethod("asyncTraceEnd", Long.TYPE, String.class, Integer.TYPE);
                }
                sAsyncTraceEndMethod.invoke(null, sTraceTagApp, methodName, cookie);
            }
            catch (Exception exception) {
                Trace.handleException("asyncTraceEnd", exception);
            }
        }
    }

    private static void setCounterFallback(@NonNull String counterName, int counterValue) {
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                if (sTraceCounterMethod == null) {
                    sTraceCounterMethod = android.os.Trace.class.getMethod("traceCounter", Long.TYPE, String.class, Integer.TYPE);
                }
                sTraceCounterMethod.invoke(null, sTraceTagApp, counterName, counterValue);
            }
            catch (Exception exception) {
                Trace.handleException("traceCounter", exception);
            }
        }
    }

    private static void handleException(@NonNull String methodName, @NonNull Exception exception) {
        if (exception instanceof InvocationTargetException) {
            Throwable cause = exception.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new RuntimeException(cause);
        }
        Log.v((String)TAG, (String)("Unable to call " + methodName + " via reflection"), (Throwable)exception);
    }

    private Trace() {
    }
}

