/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.SharedValues;

public class ReactiveGuide
extends View
implements SharedValues.SharedValuesListener {
    private int mAttributeId = -1;
    private boolean mAnimateChange = false;
    private int mApplyToConstraintSetId = 0;
    private boolean mApplyToAllConstraintSets = true;

    public ReactiveGuide(Context context) {
        super(context);
        super.setVisibility(8);
        this.init(null);
    }

    public ReactiveGuide(Context context, AttributeSet attrs) {
        super(context, attrs);
        super.setVisibility(8);
        this.init(attrs);
    }

    public ReactiveGuide(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        super.setVisibility(8);
        this.init(attrs);
    }

    public ReactiveGuide(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        super.setVisibility(8);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_ReactiveGuide);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr2 = a.getIndex(i);
                if (attr2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_valueId) {
                    this.mAttributeId = a.getResourceId(attr2, this.mAttributeId);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_animateChange) {
                    this.mAnimateChange = a.getBoolean(attr2, this.mAnimateChange);
                    continue;
                }
                if (attr2 == R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_applyToConstraintSet) {
                    this.mApplyToConstraintSetId = a.getResourceId(attr2, this.mApplyToConstraintSetId);
                    continue;
                }
                if (attr2 != R.styleable.ConstraintLayout_ReactiveGuide_reactiveGuide_applyToAllConstraintSets) continue;
                this.mApplyToAllConstraintSets = a.getBoolean(attr2, this.mApplyToAllConstraintSets);
            }
            a.recycle();
        }
        if (this.mAttributeId != -1) {
            SharedValues sharedValues = ConstraintLayout.getSharedValues();
            sharedValues.addListener(this.mAttributeId, this);
        }
    }

    public int getAttributeId() {
        return this.mAttributeId;
    }

    public void setAttributeId(int id2) {
        SharedValues sharedValues = ConstraintLayout.getSharedValues();
        if (this.mAttributeId != -1) {
            sharedValues.removeListener(this.mAttributeId, this);
        }
        this.mAttributeId = id2;
        if (this.mAttributeId != -1) {
            sharedValues.addListener(this.mAttributeId, this);
        }
    }

    public int getApplyToConstraintSetId() {
        return this.mApplyToConstraintSetId;
    }

    public void setApplyToConstraintSetId(int id2) {
        this.mApplyToConstraintSetId = id2;
    }

    public boolean isAnimatingChange() {
        return this.mAnimateChange;
    }

    public void setAnimateChange(boolean animate) {
        this.mAnimateChange = animate;
    }

    public void setVisibility(int visibility) {
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void draw(Canvas canvas) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(0, 0);
    }

    public void setGuidelineBegin(int margin) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        params.guideBegin = margin;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setGuidelineEnd(int margin) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        params.guideEnd = margin;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public void setGuidelinePercent(float ratio) {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.getLayoutParams();
        params.guidePercent = ratio;
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void onNewValue(int key, int newValue, int oldValue) {
        this.setGuidelineBegin(newValue);
        int id2 = this.getId();
        if (id2 <= 0) {
            return;
        }
        if (this.getParent() instanceof MotionLayout) {
            MotionLayout motionLayout = (MotionLayout)this.getParent();
            int currentState = motionLayout.getCurrentState();
            if (this.mApplyToConstraintSetId != 0) {
                currentState = this.mApplyToConstraintSetId;
            }
            if (this.mAnimateChange) {
                if (this.mApplyToAllConstraintSets) {
                    int[] ids = motionLayout.getConstraintSetIds();
                    for (int i = 0; i < ids.length; ++i) {
                        int cs = ids[i];
                        if (cs == currentState) continue;
                        this.changeValue(newValue, id2, motionLayout, cs);
                    }
                }
                ConstraintSet constraintSet = motionLayout.cloneConstraintSet(currentState);
                constraintSet.setGuidelineEnd(id2, newValue);
                motionLayout.updateStateAnimate(currentState, constraintSet, 1000);
            } else if (this.mApplyToAllConstraintSets) {
                int[] ids = motionLayout.getConstraintSetIds();
                for (int i = 0; i < ids.length; ++i) {
                    int cs = ids[i];
                    this.changeValue(newValue, id2, motionLayout, cs);
                }
            } else {
                this.changeValue(newValue, id2, motionLayout, currentState);
            }
        }
    }

    private void changeValue(int newValue, int id2, MotionLayout motionLayout, int currentState) {
        ConstraintSet constraintSet = motionLayout.getConstraintSet(currentState);
        constraintSet.setGuidelineEnd(id2, newValue);
        motionLayout.updateState(currentState, constraintSet);
    }
}

