/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import androidx.window.core.Version;
import androidx.window.layout.ExtensionInterfaceCompat;
import androidx.window.layout.SidecarCompat;
import androidx.window.layout.WindowBackend;
import androidx.window.layout.WindowLayoutInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0003\u001c\u001d\u001eB\u0011\b\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016R \u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\"\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Landroidx/window/layout/SidecarWindowBackend;", "Landroidx/window/layout/WindowBackend;", "windowExtension", "Landroidx/window/layout/ExtensionInterfaceCompat;", "(Landroidx/window/layout/ExtensionInterfaceCompat;)V", "getWindowExtension", "()Landroidx/window/layout/ExtensionInterfaceCompat;", "setWindowExtension", "windowLayoutChangeCallbacks", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Landroidx/window/layout/SidecarWindowBackend$WindowLayoutChangeCallbackWrapper;", "getWindowLayoutChangeCallbacks$annotations", "()V", "getWindowLayoutChangeCallbacks", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "callbackRemovedForActivity", "", "activity", "Landroid/app/Activity;", "isActivityRegistered", "", "registerLayoutChangeCallback", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "unregisterLayoutChangeCallback", "Companion", "ExtensionListenerImpl", "WindowLayoutChangeCallbackWrapper", "window_release"})
public final class SidecarWindowBackend
implements WindowBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @VisibleForTesting
    @GuardedBy(value="globalLock")
    @Nullable
    private ExtensionInterfaceCompat windowExtension;
    @NotNull
    private final CopyOnWriteArrayList<WindowLayoutChangeCallbackWrapper> windowLayoutChangeCallbacks;
    public static final boolean DEBUG = false;
    @Nullable
    private static volatile SidecarWindowBackend globalInstance;
    @NotNull
    private static final ReentrantLock globalLock;
    @NotNull
    private static final String TAG = "WindowServer";

    @VisibleForTesting
    public SidecarWindowBackend(@Nullable ExtensionInterfaceCompat windowExtension) {
        this.windowExtension = windowExtension;
        this.windowLayoutChangeCallbacks = new CopyOnWriteArrayList();
        ExtensionInterfaceCompat extensionInterfaceCompat = this.windowExtension;
        if (extensionInterfaceCompat != null) {
            extensionInterfaceCompat.setExtensionCallback(new ExtensionListenerImpl());
        }
    }

    @Nullable
    public final ExtensionInterfaceCompat getWindowExtension() {
        return this.windowExtension;
    }

    public final void setWindowExtension(@Nullable ExtensionInterfaceCompat extensionInterfaceCompat) {
        this.windowExtension = extensionInterfaceCompat;
    }

    @NotNull
    public final CopyOnWriteArrayList<WindowLayoutChangeCallbackWrapper> getWindowLayoutChangeCallbacks() {
        return this.windowLayoutChangeCallbacks;
    }

    @VisibleForTesting
    public static /* synthetic */ void getWindowLayoutChangeCallbacks$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerLayoutChangeCallback(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Lock lock = globalLock;
        lock.lock();
        try {
            boolean bl = false;
            ExtensionInterfaceCompat windowExtension = this.getWindowExtension();
            if (windowExtension == null) {
                callback.accept((Object)new WindowLayoutInfo(CollectionsKt.emptyList()));
                return;
            }
            boolean isActivityRegistered = this.isActivityRegistered(activity);
            WindowLayoutChangeCallbackWrapper callbackWrapper = new WindowLayoutChangeCallbackWrapper(activity, executor, callback);
            this.getWindowLayoutChangeCallbacks().add(callbackWrapper);
            if (!isActivityRegistered) {
                windowExtension.onWindowLayoutChangeListenerAdded(activity);
            } else {
                WindowLayoutInfo lastInfo;
                Object v0;
                block9: {
                    Iterable $this$firstOrNull$iv = this.getWindowLayoutChangeCallbacks();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WindowLayoutChangeCallbackWrapper it = (WindowLayoutChangeCallbackWrapper)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)activity, (Object)it.getActivity())) continue;
                        v0 = element$iv;
                        break block9;
                    }
                    v0 = null;
                }
                WindowLayoutChangeCallbackWrapper windowLayoutChangeCallbackWrapper = v0;
                WindowLayoutInfo windowLayoutInfo2 = lastInfo = windowLayoutChangeCallbackWrapper == null ? null : windowLayoutChangeCallbackWrapper.getLastInfo();
                if (lastInfo != null) {
                    callbackWrapper.accept(lastInfo);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final boolean isActivityRegistered(Activity activity) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.windowLayoutChangeCallbacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WindowLayoutChangeCallbackWrapper callbackWrapper = (WindowLayoutChangeCallbackWrapper)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)callbackWrapper.getActivity(), (Object)activity)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterLayoutChangeCallback(@NotNull Consumer<WindowLayoutInfo> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        ReentrantLock reentrantLock = globalLock;
        synchronized (reentrantLock) {
            boolean bl = false;
            if (this.getWindowExtension() == null) {
                return;
            }
            List itemsToRemove = new ArrayList();
            for (WindowLayoutChangeCallbackWrapper callbackWrapper : this.getWindowLayoutChangeCallbacks()) {
                Consumer<WindowLayoutInfo> registeredCallback = callbackWrapper.getCallback();
                if (registeredCallback != callback) continue;
                Intrinsics.checkNotNullExpressionValue((Object)callbackWrapper, (String)"callbackWrapper");
                itemsToRemove.add(callbackWrapper);
            }
            this.getWindowLayoutChangeCallbacks().removeAll(itemsToRemove);
            for (WindowLayoutChangeCallbackWrapper callbackWrapper : itemsToRemove) {
                this.callbackRemovedForActivity(callbackWrapper.getActivity());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @GuardedBy(value="sLock")
    private final void callbackRemovedForActivity(Activity activity) {
        boolean hasRegisteredCallback;
        block5: {
            boolean bl;
            Iterable $this$any$iv = this.windowLayoutChangeCallbacks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    WindowLayoutChangeCallbackWrapper wrapper = (WindowLayoutChangeCallbackWrapper)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)wrapper.getActivity(), (Object)activity)) continue;
                    bl = true;
                    break block5;
                }
                bl = hasRegisteredCallback = false;
            }
        }
        if (hasRegisteredCallback) {
            return;
        }
        ExtensionInterfaceCompat extensionInterfaceCompat = this.windowExtension;
        if (extensionInterfaceCompat != null) {
            extensionInterfaceCompat.onWindowLayoutChangeListenerRemoved(activity);
        }
    }

    static {
        globalLock = new ReentrantLock();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0081\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Landroidx/window/layout/SidecarWindowBackend$ExtensionListenerImpl;", "Landroidx/window/layout/ExtensionInterfaceCompat$ExtensionCallbackInterface;", "(Landroidx/window/layout/SidecarWindowBackend;)V", "onWindowLayoutChanged", "", "activity", "Landroid/app/Activity;", "newLayout", "Landroidx/window/layout/WindowLayoutInfo;", "window_release"})
    @VisibleForTesting
    public final class ExtensionListenerImpl
    implements ExtensionInterfaceCompat.ExtensionCallbackInterface {
        public ExtensionListenerImpl() {
            Intrinsics.checkNotNullParameter((Object)SidecarWindowBackend.this, (String)"this$0");
        }

        @Override
        @SuppressLint(value={"SyntheticAccessor"})
        public void onWindowLayoutChanged(@NotNull Activity activity, @NotNull WindowLayoutInfo newLayout) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)newLayout, (String)"newLayout");
            for (WindowLayoutChangeCallbackWrapper callbackWrapper : SidecarWindowBackend.this.getWindowLayoutChangeCallbacks()) {
                if (!Intrinsics.areEqual((Object)callbackWrapper.getActivity(), (Object)activity)) continue;
                callbackWrapper.accept(newLayout);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0016"}, d2={"Landroidx/window/layout/SidecarWindowBackend$WindowLayoutChangeCallbackWrapper;", "", "activity", "Landroid/app/Activity;", "executor", "Ljava/util/concurrent/Executor;", "callback", "Landroidx/core/util/Consumer;", "Landroidx/window/layout/WindowLayoutInfo;", "(Landroid/app/Activity;Ljava/util/concurrent/Executor;Landroidx/core/util/Consumer;)V", "getActivity", "()Landroid/app/Activity;", "getCallback", "()Landroidx/core/util/Consumer;", "lastInfo", "getLastInfo", "()Landroidx/window/layout/WindowLayoutInfo;", "setLastInfo", "(Landroidx/window/layout/WindowLayoutInfo;)V", "accept", "", "newLayoutInfo", "window_release"})
    public static final class WindowLayoutChangeCallbackWrapper {
        @NotNull
        private final Activity activity;
        @NotNull
        private final Executor executor;
        @NotNull
        private final Consumer<WindowLayoutInfo> callback;
        @Nullable
        private WindowLayoutInfo lastInfo;

        public WindowLayoutChangeCallbackWrapper(@NotNull Activity activity, @NotNull Executor executor, @NotNull Consumer<WindowLayoutInfo> callback) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter(callback, (String)"callback");
            this.activity = activity;
            this.executor = executor;
            this.callback = callback;
        }

        @NotNull
        public final Activity getActivity() {
            return this.activity;
        }

        @NotNull
        public final Consumer<WindowLayoutInfo> getCallback() {
            return this.callback;
        }

        @Nullable
        public final WindowLayoutInfo getLastInfo() {
            return this.lastInfo;
        }

        public final void setLastInfo(@Nullable WindowLayoutInfo windowLayoutInfo2) {
            this.lastInfo = windowLayoutInfo2;
        }

        public final void accept(@NotNull WindowLayoutInfo newLayoutInfo) {
            Intrinsics.checkNotNullParameter((Object)newLayoutInfo, (String)"newLayoutInfo");
            this.lastInfo = newLayoutInfo;
            this.executor.execute(() -> WindowLayoutChangeCallbackWrapper.accept$lambda-0(this, newLayoutInfo));
        }

        private static final void accept$lambda-0(WindowLayoutChangeCallbackWrapper this$0, WindowLayoutInfo $newLayoutInfo) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$newLayoutInfo, (String)"$newLayoutInfo");
            this$0.callback.accept((Object)$newLayoutInfo);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/window/layout/SidecarWindowBackend$Companion;", "", "()V", "DEBUG", "", "TAG", "", "globalInstance", "Landroidx/window/layout/SidecarWindowBackend;", "globalLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getInstance", "context", "Landroid/content/Context;", "initAndVerifyExtension", "Landroidx/window/layout/ExtensionInterfaceCompat;", "isSidecarVersionSupported", "sidecarVersion", "Landroidx/window/core/Version;", "resetInstance", "", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final SidecarWindowBackend getInstance(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (globalInstance == null) {
                Lock lock = globalLock;
                lock.lock();
                try {
                    boolean bl = false;
                    if (globalInstance == null) {
                        ExtensionInterfaceCompat windowExtension = Companion.initAndVerifyExtension(context);
                        globalInstance = new SidecarWindowBackend(windowExtension);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
            SidecarWindowBackend sidecarWindowBackend = globalInstance;
            Intrinsics.checkNotNull((Object)sidecarWindowBackend);
            return sidecarWindowBackend;
        }

        @Nullable
        public final ExtensionInterfaceCompat initAndVerifyExtension(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ExtensionInterfaceCompat impl = null;
            try {
                if (this.isSidecarVersionSupported(SidecarCompat.Companion.getSidecarVersion()) && !((SidecarCompat)(impl = (ExtensionInterfaceCompat)new SidecarCompat(context))).validateExtensionInterface()) {
                    impl = null;
                }
            }
            catch (Throwable t) {
                impl = null;
            }
            if (impl == null) {
            }
            return impl;
        }

        @VisibleForTesting
        public final boolean isSidecarVersionSupported(@Nullable Version sidecarVersion) {
            if (sidecarVersion == null) {
                return false;
            }
            return sidecarVersion.compareTo(Version.Companion.getVERSION_0_1()) >= 0;
        }

        @VisibleForTesting
        public final void resetInstance() {
            globalInstance = null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

