/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.constraintlayout.widget.R;
import androidx.constraintlayout.widget.VirtualLayout;
import java.util.Arrays;

public class CircularFlow
extends VirtualLayout {
    private static final String TAG = "CircularFlow";
    ConstraintLayout mContainer;
    int mViewCenter;
    private static int DEFAULT_RADIUS = 0;
    private static float DEFAULT_ANGLE = 0.0f;
    private float[] mAngles;
    private int[] mRadius;
    private int mCountRadius;
    private int mCountAngle;
    private String mReferenceAngles;
    private String mReferenceRadius;
    private Float mReferenceDefaultAngle;
    private Integer mReferenceDefaultRadius;

    public CircularFlow(Context context) {
        super(context);
    }

    public CircularFlow(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CircularFlow(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public int[] getRadius() {
        return Arrays.copyOf(this.mRadius, this.mCountRadius);
    }

    public float[] getAngles() {
        return Arrays.copyOf(this.mAngles, this.mCountAngle);
    }

    @Override
    protected void init(AttributeSet attrs) {
        super.init(attrs);
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.ConstraintLayout_Layout_circularflow_viewCenter) {
                    this.mViewCenter = a.getResourceId(attr, 0);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_circularflow_angles) {
                    this.mReferenceAngles = a.getString(attr);
                    this.setAngles(this.mReferenceAngles);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_circularflow_radiusInDP) {
                    this.mReferenceRadius = a.getString(attr);
                    this.setRadius(this.mReferenceRadius);
                    continue;
                }
                if (attr == R.styleable.ConstraintLayout_Layout_circularflow_defaultAngle) {
                    this.mReferenceDefaultAngle = Float.valueOf(a.getFloat(attr, DEFAULT_ANGLE));
                    this.setDefaultAngle(this.mReferenceDefaultAngle.floatValue());
                    continue;
                }
                if (attr != R.styleable.ConstraintLayout_Layout_circularflow_defaultRadius) continue;
                this.mReferenceDefaultRadius = a.getDimensionPixelSize(attr, DEFAULT_RADIUS);
                this.setDefaultRadius(this.mReferenceDefaultRadius);
            }
            a.recycle();
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mReferenceAngles != null) {
            this.mAngles = new float[1];
            this.setAngles(this.mReferenceAngles);
        }
        if (this.mReferenceRadius != null) {
            this.mRadius = new int[1];
            this.setRadius(this.mReferenceRadius);
        }
        if (this.mReferenceDefaultAngle != null) {
            this.setDefaultAngle(this.mReferenceDefaultAngle.floatValue());
        }
        if (this.mReferenceDefaultRadius != null) {
            this.setDefaultRadius(this.mReferenceDefaultRadius);
        }
        this.anchorReferences();
    }

    private void anchorReferences() {
        this.mContainer = (ConstraintLayout)this.getParent();
        for (int i = 0; i < this.mCount; ++i) {
            View view = this.mContainer.getViewById(this.mIds[i]);
            if (view == null) continue;
            int radius = DEFAULT_RADIUS;
            float angle = DEFAULT_ANGLE;
            if (this.mRadius != null && i < this.mRadius.length) {
                radius = this.mRadius[i];
            } else if (this.mReferenceDefaultRadius != null && this.mReferenceDefaultRadius != -1) {
                ++this.mCountRadius;
                if (this.mRadius == null) {
                    this.mRadius = new int[1];
                }
                this.mRadius = this.getRadius();
                this.mRadius[this.mCountRadius - 1] = radius;
            } else {
                Log.e((String)TAG, (String)("Added radius to view with id: " + (String)this.mMap.get(view.getId())));
            }
            if (this.mAngles != null && i < this.mAngles.length) {
                angle = this.mAngles[i];
            } else if (this.mReferenceDefaultAngle != null && this.mReferenceDefaultAngle.floatValue() != -1.0f) {
                ++this.mCountAngle;
                if (this.mAngles == null) {
                    this.mAngles = new float[1];
                }
                this.mAngles = this.getAngles();
                this.mAngles[this.mCountAngle - 1] = angle;
            } else {
                Log.e((String)TAG, (String)("Added angle to view with id: " + (String)this.mMap.get(view.getId())));
            }
            ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)view.getLayoutParams();
            params.circleAngle = angle;
            params.circleConstraint = this.mViewCenter;
            params.circleRadius = radius;
            view.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        this.applyLayoutFeatures();
    }

    public void addViewToCircularFlow(View view, int radius, float angle) {
        if (this.containsId(view.getId())) {
            return;
        }
        this.addView(view);
        ++this.mCountAngle;
        this.mAngles = this.getAngles();
        this.mAngles[this.mCountAngle - 1] = angle;
        ++this.mCountRadius;
        this.mRadius = this.getRadius();
        this.mRadius[this.mCountRadius - 1] = (int)((float)radius * this.myContext.getResources().getDisplayMetrics().density);
        this.anchorReferences();
    }

    public void updateRadius(View view, int radius) {
        if (!this.isUpdatable(view)) {
            Log.e((String)TAG, (String)("It was not possible to update radius to view with id: " + view.getId()));
            return;
        }
        int indexView = this.indexFromId(view.getId());
        if (indexView > this.mRadius.length) {
            return;
        }
        this.mRadius = this.getRadius();
        this.mRadius[indexView] = (int)((float)radius * this.myContext.getResources().getDisplayMetrics().density);
        this.anchorReferences();
    }

    public void updateAngle(View view, float angle) {
        if (!this.isUpdatable(view)) {
            Log.e((String)TAG, (String)("It was not possible to update angle to view with id: " + view.getId()));
            return;
        }
        int indexView = this.indexFromId(view.getId());
        if (indexView > this.mAngles.length) {
            return;
        }
        this.mAngles = this.getAngles();
        this.mAngles[indexView] = angle;
        this.anchorReferences();
    }

    public void updateReference(View view, int radius, float angle) {
        if (!this.isUpdatable(view)) {
            Log.e((String)TAG, (String)("It was not possible to update radius and angle to view with id: " + view.getId()));
            return;
        }
        int indexView = this.indexFromId(view.getId());
        if (this.getAngles().length > indexView) {
            this.mAngles = this.getAngles();
            this.mAngles[indexView] = angle;
        }
        if (this.getRadius().length > indexView) {
            this.mRadius = this.getRadius();
            this.mRadius[indexView] = (int)((float)radius * this.myContext.getResources().getDisplayMetrics().density);
        }
        this.anchorReferences();
    }

    public void setDefaultAngle(float angle) {
        DEFAULT_ANGLE = angle;
    }

    public void setDefaultRadius(int radius) {
        DEFAULT_RADIUS = radius;
    }

    @Override
    public int removeView(View view) {
        int index = super.removeView(view);
        if (index == -1) {
            return index;
        }
        ConstraintSet c = new ConstraintSet();
        c.clone(this.mContainer);
        c.clear(view.getId(), 8);
        c.applyTo(this.mContainer);
        if (index < this.mAngles.length) {
            this.mAngles = this.removeAngle(this.mAngles, index);
            --this.mCountAngle;
        }
        if (index < this.mRadius.length) {
            this.mRadius = this.removeRadius(this.mRadius, index);
            --this.mCountRadius;
        }
        this.anchorReferences();
        return index;
    }

    private float[] removeAngle(float[] angles, int index) {
        if (angles == null || index < 0 || index >= this.mCountAngle) {
            return angles;
        }
        return CircularFlow.removeElementFromArray(angles, index);
    }

    private int[] removeRadius(int[] radius, int index) {
        if (radius == null || index < 0 || index >= this.mCountRadius) {
            return radius;
        }
        return CircularFlow.removeElementFromArray(radius, index);
    }

    private void setAngles(String idList) {
        if (idList == null) {
            return;
        }
        int begin = 0;
        this.mCountAngle = 0;
        while (true) {
            int end;
            if ((end = idList.indexOf(44, begin)) == -1) break;
            this.addAngle(idList.substring(begin, end).trim());
            begin = end + 1;
        }
        this.addAngle(idList.substring(begin).trim());
    }

    private void setRadius(String idList) {
        if (idList == null) {
            return;
        }
        int begin = 0;
        this.mCountRadius = 0;
        while (true) {
            int end;
            if ((end = idList.indexOf(44, begin)) == -1) break;
            this.addRadius(idList.substring(begin, end).trim());
            begin = end + 1;
        }
        this.addRadius(idList.substring(begin).trim());
    }

    private void addAngle(String angleString) {
        if (angleString == null || angleString.length() == 0) {
            return;
        }
        if (this.myContext == null) {
            return;
        }
        if (this.mAngles == null) {
            return;
        }
        if (this.mCountAngle + 1 > this.mAngles.length) {
            this.mAngles = Arrays.copyOf(this.mAngles, this.mAngles.length + 1);
        }
        this.mAngles[this.mCountAngle] = Integer.parseInt(angleString);
        ++this.mCountAngle;
    }

    private void addRadius(String radiusString) {
        if (radiusString == null || radiusString.length() == 0) {
            return;
        }
        if (this.myContext == null) {
            return;
        }
        if (this.mRadius == null) {
            return;
        }
        if (this.mCountRadius + 1 > this.mRadius.length) {
            this.mRadius = Arrays.copyOf(this.mRadius, this.mRadius.length + 1);
        }
        this.mRadius[this.mCountRadius] = (int)((float)Integer.parseInt(radiusString) * this.myContext.getResources().getDisplayMetrics().density);
        ++this.mCountRadius;
    }

    public static int[] removeElementFromArray(int[] array, int index) {
        int[] newArray = new int[array.length - 1];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) continue;
            newArray[k++] = array[i];
        }
        return newArray;
    }

    public static float[] removeElementFromArray(float[] array, int index) {
        float[] newArray = new float[array.length - 1];
        int k = 0;
        for (int i = 0; i < array.length; ++i) {
            if (i == index) continue;
            newArray[k++] = array[i];
        }
        return newArray;
    }

    public boolean isUpdatable(View view) {
        if (!this.containsId(view.getId())) {
            return false;
        }
        int indexView = this.indexFromId(view.getId());
        return indexView != -1;
    }
}

