/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.fragment;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.CallSuper;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.NavigatorState;
import androidx.navigation.fragment.R;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Navigator.Name(value="dialog")
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u001f B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator;", "Landroidx/navigation/Navigator;", "Landroidx/navigation/fragment/DialogFragmentNavigator$Destination;", "context", "Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "(Landroid/content/Context;Landroidx/fragment/app/FragmentManager;)V", "observer", "Landroidx/lifecycle/LifecycleEventObserver;", "restoredTagsAwaitingAttach", "", "", "createDestination", "navigate", "", "entry", "Landroidx/navigation/NavBackStackEntry;", "entries", "", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "onAttach", "state", "Landroidx/navigation/NavigatorState;", "popBackStack", "popUpTo", "savedState", "", "Companion", "Destination", "navigation-fragment_release"})
public final class DialogFragmentNavigator
extends Navigator<Destination> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final FragmentManager fragmentManager;
    @NotNull
    private final Set<String> restoredTagsAwaitingAttach;
    @NotNull
    private final LifecycleEventObserver observer;
    @Deprecated
    @NotNull
    private static final String TAG = "DialogFragmentNavigator";

    public DialogFragmentNavigator(@NotNull Context context, @NotNull FragmentManager fragmentManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        this.context = context;
        this.fragmentManager = fragmentManager;
        this.restoredTagsAwaitingAttach = new LinkedHashSet();
        this.observer = (arg_0, arg_1) -> DialogFragmentNavigator.observer$lambda-3(this, arg_0, arg_1);
    }

    public void popBackStack(@NotNull NavBackStackEntry popUpTo, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring popBackStack() call: FragmentManager has already saved its state");
            return;
        }
        List beforePopList = (List)this.getState().getBackStack().getValue();
        List poppedList = beforePopList.subList(beforePopList.indexOf(popUpTo), beforePopList.size());
        for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)poppedList)) {
            Fragment existingFragment = this.fragmentManager.findFragmentByTag(entry.getId());
            if (existingFragment == null) continue;
            existingFragment.getLifecycle().removeObserver((LifecycleObserver)this.observer);
            ((DialogFragment)existingFragment).dismiss();
        }
        this.getState().pop(popUpTo, savedState);
    }

    @NotNull
    public Destination createDestination() {
        return new Destination((Navigator<? extends Destination>)((Navigator)this));
    }

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (this.fragmentManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return;
        }
        for (NavBackStackEntry entry : entries) {
            this.navigate(entry);
        }
    }

    private final void navigate(NavBackStackEntry entry) {
        Destination destination = (Destination)entry.getDestination();
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = Intrinsics.stringPlus((String)this.context.getPackageName(), (Object)className);
        }
        Fragment fragment = this.fragmentManager.getFragmentFactory().instantiate(this.context.getClassLoader(), className);
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentManager.fragment\u2026ader, className\n        )");
        Fragment frag = fragment;
        if (!DialogFragment.class.isAssignableFrom(frag.getClass())) {
            boolean bl = false;
            String string = "Dialog destination " + destination.getClassName() + " is not an instance of DialogFragment";
            throw new IllegalArgumentException(string.toString());
        }
        DialogFragment dialogFragment = (DialogFragment)frag;
        dialogFragment.setArguments(entry.getArguments());
        dialogFragment.getLifecycle().addObserver((LifecycleObserver)this.observer);
        dialogFragment.show(this.fragmentManager, entry.getId());
        this.getState().push(entry);
    }

    public void onAttach(@NotNull NavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onAttach(state);
        for (NavBackStackEntry entry : (List)state.getBackStack().getValue()) {
            Unit unit;
            Unit unit2;
            DialogFragment fragment;
            DialogFragment dialogFragment = fragment = (DialogFragment)this.fragmentManager.findFragmentByTag(entry.getId());
            if (dialogFragment == null) {
                unit2 = null;
            } else {
                Lifecycle lifecycle = dialogFragment.getLifecycle();
                if (lifecycle == null) {
                    unit2 = null;
                } else {
                    lifecycle.addObserver((LifecycleObserver)this.observer);
                    unit2 = Unit.INSTANCE;
                }
            }
            if ((unit = unit2) != null) continue;
            this.restoredTagsAwaitingAttach.add(entry.getId());
        }
        this.fragmentManager.addFragmentOnAttachListener((arg_0, arg_1) -> DialogFragmentNavigator.onAttach$lambda-5(this, arg_0, arg_1));
    }

    private static final void observer$lambda-3(DialogFragmentNavigator this$0, LifecycleOwner source, Lifecycle.Event event) {
        DialogFragment dialogFragment;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event == Lifecycle.Event.ON_CREATE) {
            boolean dialogOnBackStack;
            DialogFragment dialogFragment2;
            block10: {
                boolean bl;
                dialogFragment2 = (DialogFragment)source;
                Iterable $this$any$iv = (Iterable)this$0.getState().getBackStack().getValue();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        NavBackStackEntry it = (NavBackStackEntry)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)dialogFragment2.getTag())) continue;
                        bl = true;
                        break block10;
                    }
                    bl = dialogOnBackStack = false;
                }
            }
            if (!dialogOnBackStack) {
                dialogFragment2.dismiss();
            }
        } else if (event == Lifecycle.Event.ON_STOP && !(dialogFragment = (DialogFragment)source).requireDialog().isShowing()) {
            Object v1;
            List beforePopList;
            block11: {
                List $this$lastOrNull$iv = beforePopList = (List)this$0.getState().getBackStack().getValue();
                boolean $i$f$lastOrNull = false;
                ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Object element$iv = iterator$iv.previous();
                    NavBackStackEntry it = (NavBackStackEntry)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)dialogFragment.getTag())) continue;
                    v1 = element$iv;
                    break block11;
                }
                v1 = null;
            }
            if (v1 == null) {
                boolean bl = false;
                String string = "Dialog " + dialogFragment + " has already been popped off of the Navigation back stack";
                throw new IllegalStateException(string.toString());
            }
            NavBackStackEntry poppedEntry = v1;
            if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull((List)beforePopList), (Object)poppedEntry)) {
                Log.i((String)TAG, (String)("Dialog " + dialogFragment + " was dismissed while it was not the top of the back stack, popping all dialogs above this dismissed dialog"));
            }
            this$0.popBackStack(poppedEntry, false);
        }
    }

    private static final void onAttach$lambda-5(DialogFragmentNavigator this$0, FragmentManager $noName_0, Fragment childFragment) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$noName_0, (String)"$noName_0");
        Intrinsics.checkNotNullParameter((Object)childFragment, (String)"childFragment");
        boolean needToAddObserver = ((Collection)this$0.restoredTagsAwaitingAttach).remove(childFragment.getTag());
        if (needToAddObserver) {
            childFragment.getLifecycle().addObserver((LifecycleObserver)this$0.observer);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0017J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator$Destination;", "Landroidx/navigation/NavDestination;", "Landroidx/navigation/FloatingWindow;", "navigatorProvider", "Landroidx/navigation/NavigatorProvider;", "(Landroidx/navigation/NavigatorProvider;)V", "fragmentNavigator", "Landroidx/navigation/Navigator;", "(Landroidx/navigation/Navigator;)V", "_className", "", "className", "getClassName", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "onInflate", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "setClassName", "navigation-fragment_release"})
    @NavDestination.ClassType(value=DialogFragment.class)
    public static class Destination
    extends NavDestination
    implements FloatingWindow {
        @Nullable
        private String _className;

        public Destination(@NotNull Navigator<? extends Destination> fragmentNavigator) {
            Intrinsics.checkNotNullParameter(fragmentNavigator, (String)"fragmentNavigator");
            super(fragmentNavigator);
        }

        @NotNull
        public final String getClassName() {
            if (this._className == null) {
                boolean bl = false;
                String string = "DialogFragment class was not set";
                throw new IllegalStateException(string.toString());
            }
            String string = this._className;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            return string;
        }

        public Destination(@NotNull NavigatorProvider navigatorProvider) {
            Intrinsics.checkNotNullParameter((Object)navigatorProvider, (String)"navigatorProvider");
            this((Navigator<? extends Destination>)navigatorProvider.getNavigator(DialogFragmentNavigator.class));
        }

        @CallSuper
        public void onInflate(@NotNull Context context, @NotNull AttributeSet attrs) {
            Destination destination;
            Destination destination2;
            String className;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
            super.onInflate(context, attrs);
            TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.DialogFragmentNavigator);
            Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.resources.obtain\u2026ntNavigator\n            )");
            TypedArray $this$use$iv = typedArray;
            boolean $i$f$use = false;
            TypedArray array = $this$use$iv;
            boolean bl = false;
            String string = className = array.getString(R.styleable.DialogFragmentNavigator_android_name);
            if (string == null) {
                destination2 = null;
            } else {
                String it = string;
                boolean bl2 = false;
                destination2 = this.setClassName(it);
            }
            Destination it$iv = destination = destination2;
            boolean bl3 = false;
            $this$use$iv.recycle();
        }

        @NotNull
        public final Destination setClassName(@NotNull String className) {
            Intrinsics.checkNotNullParameter((Object)className, (String)"className");
            this._className = className;
            return this;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null || !(other instanceof Destination)) {
                return false;
            }
            return super.equals(other) && Intrinsics.areEqual((Object)this._className, (Object)((Destination)((Object)other))._className);
        }

        public int hashCode() {
            int result = super.hashCode();
            String string = this._className;
            result = 31 * result + (string == null ? 0 : string.hashCode());
            return result;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/navigation/fragment/DialogFragmentNavigator$Companion;", "", "()V", "TAG", "", "navigation-fragment_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

