/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation;

import android.os.Bundle;
import androidx.annotation.CallSuper;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.NavOptionsBuilder;
import androidx.navigation.NavOptionsBuilderKt;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorState;
import java.lang.annotation.ElementType;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.annotation.AnnotationRetention;
import kotlin.annotation.AnnotationTarget;
import kotlin.annotation.Retention;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0004J\r\u0010\u000e\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000fJ5\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00028\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0010\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u0006H\u0017J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u001cH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0013H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010#\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\bH\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006'"}, d2={"Landroidx/navigation/Navigator;", "D", "Landroidx/navigation/NavDestination;", "", "()V", "_state", "Landroidx/navigation/NavigatorState;", "<set-?>", "", "isAttached", "()Z", "state", "getState", "()Landroidx/navigation/NavigatorState;", "createDestination", "()Landroidx/navigation/NavDestination;", "navigate", "destination", "args", "Landroid/os/Bundle;", "navOptions", "Landroidx/navigation/NavOptions;", "navigatorExtras", "Landroidx/navigation/Navigator$Extras;", "(Landroidx/navigation/NavDestination;Landroid/os/Bundle;Landroidx/navigation/NavOptions;Landroidx/navigation/Navigator$Extras;)Landroidx/navigation/NavDestination;", "", "entries", "", "Landroidx/navigation/NavBackStackEntry;", "onAttach", "onLaunchSingleTop", "backStackEntry", "onRestoreState", "savedState", "onSaveState", "popBackStack", "popUpTo", "Extras", "Name", "navigation-common_release"})
public abstract class Navigator<D extends NavDestination> {
    @Nullable
    private NavigatorState _state;
    private boolean isAttached;

    @NotNull
    protected final NavigatorState getState() {
        NavigatorState navigatorState = this._state;
        if (navigatorState == null) {
            boolean bl = false;
            String string = "You cannot access the Navigator's state until the Navigator is attached";
            throw new IllegalStateException(string.toString());
        }
        return navigatorState;
    }

    public final boolean isAttached() {
        return this.isAttached;
    }

    @CallSuper
    public void onAttach(@NotNull NavigatorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this._state = state;
        this.isAttached = true;
    }

    @NotNull
    public abstract D createDestination();

    public void navigate(@NotNull List<NavBackStackEntry> entries, @Nullable NavOptions navOptions, @Nullable Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        Sequence $this$forEach$iv = SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)entries), (Function1)((Function1)new Function1<NavBackStackEntry, NavBackStackEntry>(this, navOptions, navigatorExtras){
            final /* synthetic */ Navigator<D> this$0;
            final /* synthetic */ NavOptions $navOptions;
            final /* synthetic */ Extras $navigatorExtras;
            {
                this.this$0 = $receiver;
                this.$navOptions = $navOptions;
                this.$navigatorExtras = $navigatorExtras;
                super(1);
            }

            @Nullable
            public final NavBackStackEntry invoke(@NotNull NavBackStackEntry backStackEntry) {
                Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
                NavDestination navDestination = backStackEntry.getDestination();
                NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
                if (navDestination2 == null) {
                    return null;
                }
                NavDestination destination = navDestination2;
                NavDestination navigatedToDestination = this.this$0.navigate(destination, backStackEntry.getArguments(), this.$navOptions, this.$navigatorExtras);
                navDestination = navigatedToDestination;
                return navDestination == null ? null : (Intrinsics.areEqual((Object)navDestination, (Object)destination) ? backStackEntry : this.this$0.getState().createBackStackEntry(navigatedToDestination, navigatedToDestination.addInDefaultArgs(backStackEntry.getArguments())));
            }
        })));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NavBackStackEntry backStackEntry = (NavBackStackEntry)element$iv;
            boolean bl = false;
            this.getState().push(backStackEntry);
        }
    }

    public void onLaunchSingleTop(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        NavDestination navDestination = backStackEntry.getDestination();
        NavDestination navDestination2 = navDestination instanceof NavDestination ? navDestination : null;
        if (navDestination2 == null) {
            return;
        }
        NavDestination destination = navDestination2;
        this.navigate(destination, null, NavOptionsBuilderKt.navOptions((Function1<? super NavOptionsBuilder, Unit>)((Function1)onLaunchSingleTop.1.INSTANCE)), null);
        this.getState().onLaunchSingleTop(backStackEntry);
    }

    @Nullable
    public NavDestination navigate(@NotNull D destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Extras navigatorExtras) {
        Intrinsics.checkNotNullParameter(destination, (String)"destination");
        return destination;
    }

    public void popBackStack(@NotNull NavBackStackEntry popUpTo2, boolean savedState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo2, (String)"popUpTo");
        List backStack = (List)this.getState().getBackStack().getValue();
        if (!backStack.contains(popUpTo2)) {
            boolean $i$a$-check-Navigator$popBackStack$22 = false;
            String $i$a$-check-Navigator$popBackStack$22 = "popBackStack was called with " + popUpTo2 + " which does not exist in back stack " + backStack;
            throw new IllegalStateException($i$a$-check-Navigator$popBackStack$22.toString());
        }
        ListIterator iterator2 = backStack.listIterator(backStack.size());
        NavBackStackEntry lastPoppedEntry = null;
        while (this.popBackStack() && !Intrinsics.areEqual((Object)(lastPoppedEntry = (NavBackStackEntry)iterator2.previous()), (Object)popUpTo2)) {
        }
        if (lastPoppedEntry != null) {
            this.getState().pop(lastPoppedEntry, savedState);
        }
    }

    public boolean popBackStack() {
        return true;
    }

    @Nullable
    public Bundle onSaveState() {
        return null;
    }

    public void onRestoreState(@NotNull Bundle savedState) {
        Intrinsics.checkNotNullParameter((Object)savedState, (String)"savedState");
    }

    @Retention(value=AnnotationRetention.RUNTIME)
    @kotlin.annotation.Target(allowedTargets={AnnotationTarget.ANNOTATION_CLASS, AnnotationTarget.CLASS})
    @java.lang.annotation.Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.ANNOTATION_TYPE})
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\u0002\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003R\u000f\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/navigation/Navigator$Name;", "", "value", "", "()Ljava/lang/String;", "navigation-common_release"})
    public static @interface Name {
        public String value();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bf\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Landroidx/navigation/Navigator$Extras;", "", "navigation-common_release"})
    public static interface Extras {
    }
}

