/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.tabs;

import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.tabs.TabLayout;

class TabIndicatorInterpolator {
    @Dimension(unit=0)
    private static final int MIN_INDICATOR_WIDTH = 24;

    TabIndicatorInterpolator() {
    }

    static RectF calculateTabViewContentBounds(@NonNull TabLayout.TabView tabView, @Dimension(unit=0) int minWidth) {
        int tabViewContentWidth = tabView.getContentWidth();
        int tabViewContentHeight = tabView.getContentHeight();
        int minWidthPx = (int)ViewUtils.dpToPx(tabView.getContext(), minWidth);
        if (tabViewContentWidth < minWidthPx) {
            tabViewContentWidth = minWidthPx;
        }
        int tabViewCenterX = (tabView.getLeft() + tabView.getRight()) / 2;
        int tabViewCenterY = (tabView.getTop() + tabView.getBottom()) / 2;
        int contentLeftBounds = tabViewCenterX - tabViewContentWidth / 2;
        int contentTopBounds = tabViewCenterY - tabViewContentHeight / 2;
        int contentRightBounds = tabViewCenterX + tabViewContentWidth / 2;
        int contentBottomBounds = tabViewCenterY + tabViewCenterX / 2;
        return new RectF((float)contentLeftBounds, (float)contentTopBounds, (float)contentRightBounds, (float)contentBottomBounds);
    }

    static RectF calculateIndicatorWidthForTab(TabLayout tabLayout, @Nullable View tab) {
        if (tab == null) {
            return new RectF();
        }
        if (!tabLayout.isTabIndicatorFullWidth() && tab instanceof TabLayout.TabView) {
            return TabIndicatorInterpolator.calculateTabViewContentBounds((TabLayout.TabView)tab, 24);
        }
        return new RectF((float)tab.getLeft(), (float)tab.getTop(), (float)tab.getRight(), (float)tab.getBottom());
    }

    void setIndicatorBoundsForTab(TabLayout tabLayout, View tab, @NonNull Drawable indicator) {
        RectF startIndicator = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, tab);
        indicator.setBounds((int)startIndicator.left, indicator.getBounds().top, (int)startIndicator.right, indicator.getBounds().bottom);
    }

    void updateIndicatorForOffset(TabLayout tabLayout, View startTitle, View endTitle, @FloatRange(from=0.0, to=1.0) float offset, @NonNull Drawable indicator) {
        RectF startIndicator = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, startTitle);
        RectF endIndicator = TabIndicatorInterpolator.calculateIndicatorWidthForTab(tabLayout, endTitle);
        indicator.setBounds(AnimationUtils.lerp((int)startIndicator.left, (int)endIndicator.left, offset), indicator.getBounds().top, AnimationUtils.lerp((int)startIndicator.right, (int)endIndicator.right, offset), indicator.getBounds().bottom);
    }
}

