/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.core.motion.utils.Easing;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.motion.widget.Key;
import androidx.constraintlayout.motion.widget.KeyPositionBase;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;

public class KeyPosition
extends KeyPositionBase {
    private static final String TAG = "KeyPosition";
    static final String NAME = "KeyPosition";
    String mTransitionEasing = null;
    int mPathMotionArc = UNSET;
    int mDrawPath = 0;
    float mPercentWidth = Float.NaN;
    float mPercentHeight = Float.NaN;
    float mPercentX = Float.NaN;
    float mPercentY = Float.NaN;
    float mAltPercentX = Float.NaN;
    float mAltPercentY = Float.NaN;
    public static final int TYPE_SCREEN = 2;
    public static final int TYPE_PATH = 1;
    public static final int TYPE_CARTESIAN = 0;
    int mPositionType = 0;
    public static final String TRANSITION_EASING = "transitionEasing";
    public static final String DRAWPATH = "drawPath";
    public static final String PERCENT_WIDTH = "percentWidth";
    public static final String PERCENT_HEIGHT = "percentHeight";
    public static final String SIZE_PERCENT = "sizePercent";
    public static final String PERCENT_X = "percentX";
    public static final String PERCENT_Y = "percentY";
    private float mCalculatedPositionX = Float.NaN;
    private float mCalculatedPositionY = Float.NaN;
    static final int KEY_TYPE = 2;

    public KeyPosition() {
        this.mType = 2;
    }

    @Override
    public void load(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.KeyPosition);
        Loader.read(this, a);
    }

    @Override
    public void addValues(HashMap<String, ViewSpline> splines) {
    }

    public void setType(int type) {
        this.mPositionType = type;
    }

    @Override
    void calcPosition(int layoutWidth, int layoutHeight, float start_x, float start_y, float end_x, float end_y) {
        switch (this.mPositionType) {
            case 2: {
                this.calcScreenPosition(layoutWidth, layoutHeight);
                return;
            }
            case 1: {
                this.calcPathPosition(start_x, start_y, end_x, end_y);
                return;
            }
        }
        this.calcCartesianPosition(start_x, start_y, end_x, end_y);
    }

    private void calcScreenPosition(int layoutWidth, int layoutHeight) {
        int viewWidth = 0;
        int viewHeight = 0;
        this.mCalculatedPositionX = (float)(layoutWidth - viewWidth) * this.mPercentX + (float)(viewWidth / 2);
        this.mCalculatedPositionY = (float)(layoutHeight - viewHeight) * this.mPercentX + (float)(viewHeight / 2);
    }

    private void calcPathPosition(float start_x, float start_y, float end_x, float end_y) {
        float pathVectorX = end_x - start_x;
        float pathVectorY = end_y - start_y;
        float perpendicularX = -pathVectorY;
        float perpendicularY = pathVectorX;
        this.mCalculatedPositionX = start_x + pathVectorX * this.mPercentX + perpendicularX * this.mPercentY;
        this.mCalculatedPositionY = start_y + pathVectorY * this.mPercentX + perpendicularY * this.mPercentY;
    }

    private void calcCartesianPosition(float start_x, float start_y, float end_x, float end_y) {
        float pathVectorX = end_x - start_x;
        float pathVectorY = end_y - start_y;
        float dxdx = Float.isNaN(this.mPercentX) ? 0.0f : this.mPercentX;
        float dydx = Float.isNaN(this.mAltPercentY) ? 0.0f : this.mAltPercentY;
        float dydy = Float.isNaN(this.mPercentY) ? 0.0f : this.mPercentY;
        float dxdy = Float.isNaN(this.mAltPercentX) ? 0.0f : this.mAltPercentX;
        this.mCalculatedPositionX = (int)(start_x + pathVectorX * dxdx + pathVectorY * dxdy);
        this.mCalculatedPositionY = (int)(start_y + pathVectorX * dydx + pathVectorY * dydy);
    }

    @Override
    float getPositionX() {
        return this.mCalculatedPositionX;
    }

    @Override
    float getPositionY() {
        return this.mCalculatedPositionY;
    }

    @Override
    public void positionAttributes(View view, RectF start, RectF end, float x, float y, String[] attribute, float[] value) {
        switch (this.mPositionType) {
            case 1: {
                this.positionPathAttributes(start, end, x, y, attribute, value);
                return;
            }
            case 2: {
                this.positionScreenAttributes(view, start, end, x, y, attribute, value);
                return;
            }
        }
        this.positionCartAttributes(start, end, x, y, attribute, value);
    }

    void positionPathAttributes(RectF start, RectF end, float x, float y, String[] attribute, float[] value) {
        float endCenterY;
        float pathVectorY;
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float pathVectorX = endCenterX - startCenterX;
        float distance = (float)Math.hypot(pathVectorX, pathVectorY = (endCenterY = end.centerY()) - startCenterY);
        if ((double)distance < 1.0E-4) {
            System.out.println("distance ~ 0");
            value[0] = 0.0f;
            value[1] = 0.0f;
            return;
        }
        float dx = pathVectorX / distance;
        float dy = pathVectorY / distance;
        float perpendicular = (dx * (y - startCenterY) - (x - startCenterX) * dy) / distance;
        float dist = (dx * (x - startCenterX) + dy * (y - startCenterY)) / distance;
        if (attribute[0] != null) {
            if (PERCENT_X.equals(attribute[0])) {
                value[0] = dist;
                value[1] = perpendicular;
            }
        } else {
            attribute[0] = PERCENT_X;
            attribute[1] = PERCENT_Y;
            value[0] = dist;
            value[1] = perpendicular;
        }
    }

    void positionScreenAttributes(View view, RectF start, RectF end, float x, float y, String[] attribute, float[] value) {
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        int width = viewGroup.getWidth();
        int height = viewGroup.getHeight();
        if (attribute[0] != null) {
            if (PERCENT_X.equals(attribute[0])) {
                value[0] = x / (float)width;
                value[1] = y / (float)height;
            } else {
                value[1] = x / (float)width;
                value[0] = y / (float)height;
            }
        } else {
            attribute[0] = PERCENT_X;
            value[0] = x / (float)width;
            attribute[1] = PERCENT_Y;
            value[1] = y / (float)height;
        }
    }

    void positionCartAttributes(RectF start, RectF end, float x, float y, String[] attribute, float[] value) {
        float startCenterX = start.centerX();
        float startCenterY = start.centerY();
        float endCenterX = end.centerX();
        float endCenterY = end.centerY();
        float pathVectorX = endCenterX - startCenterX;
        float pathVectorY = endCenterY - startCenterY;
        if (attribute[0] != null) {
            if (PERCENT_X.equals(attribute[0])) {
                value[0] = (x - startCenterX) / pathVectorX;
                value[1] = (y - startCenterY) / pathVectorY;
            } else {
                value[1] = (x - startCenterX) / pathVectorX;
                value[0] = (y - startCenterY) / pathVectorY;
            }
        } else {
            attribute[0] = PERCENT_X;
            value[0] = (x - startCenterX) / pathVectorX;
            attribute[1] = PERCENT_Y;
            value[1] = (y - startCenterY) / pathVectorY;
        }
    }

    @Override
    public boolean intersects(int layoutWidth, int layoutHeight, RectF start, RectF end, float x, float y) {
        this.calcPosition(layoutWidth, layoutHeight, start.centerX(), start.centerY(), end.centerX(), end.centerY());
        return Math.abs(x - this.mCalculatedPositionX) < 20.0f && Math.abs(y - this.mCalculatedPositionY) < 20.0f;
    }

    @Override
    public void setValue(String tag, Object value) {
        switch (tag) {
            case "transitionEasing": {
                this.mTransitionEasing = value.toString();
                break;
            }
            case "drawPath": {
                this.mDrawPath = this.toInt(value);
                break;
            }
            case "percentWidth": {
                this.mPercentWidth = this.toFloat(value);
                break;
            }
            case "percentHeight": {
                this.mPercentHeight = this.toFloat(value);
                break;
            }
            case "sizePercent": {
                this.mPercentHeight = this.mPercentWidth = this.toFloat(value);
                break;
            }
            case "percentX": {
                this.mPercentX = this.toFloat(value);
                break;
            }
            case "percentY": {
                this.mPercentY = this.toFloat(value);
            }
        }
    }

    @Override
    public Key copy(Key src) {
        super.copy(src);
        KeyPosition k = (KeyPosition)src;
        this.mTransitionEasing = k.mTransitionEasing;
        this.mPathMotionArc = k.mPathMotionArc;
        this.mDrawPath = k.mDrawPath;
        this.mPercentWidth = k.mPercentWidth;
        this.mPercentHeight = Float.NaN;
        this.mPercentX = k.mPercentX;
        this.mPercentY = k.mPercentY;
        this.mAltPercentX = k.mAltPercentX;
        this.mAltPercentY = k.mAltPercentY;
        this.mCalculatedPositionX = k.mCalculatedPositionX;
        this.mCalculatedPositionY = k.mCalculatedPositionY;
        return this;
    }

    @Override
    public Key clone() {
        return new KeyPosition().copy(this);
    }

    private static class Loader {
        private static final int TARGET_ID = 1;
        private static final int FRAME_POSITION = 2;
        private static final int TRANSITION_EASING = 3;
        private static final int CURVE_FIT = 4;
        private static final int DRAW_PATH = 5;
        private static final int PERCENT_X = 6;
        private static final int PERCENT_Y = 7;
        private static final int SIZE_PERCENT = 8;
        private static final int TYPE = 9;
        private static final int PATH_MOTION_ARC = 10;
        private static final int PERCENT_WIDTH = 11;
        private static final int PERCENT_HEIGHT = 12;
        private static SparseIntArray mAttrMap = new SparseIntArray();

        private Loader() {
        }

        private static void read(KeyPosition c, TypedArray a) {
            int N = a.getIndexCount();
            block14: for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                switch (mAttrMap.get(attr)) {
                    case 1: {
                        if (MotionLayout.IS_IN_EDIT_MODE) {
                            c.mTargetId = a.getResourceId(attr, c.mTargetId);
                            if (c.mTargetId != -1) continue block14;
                            c.mTargetString = a.getString(attr);
                            continue block14;
                        }
                        if (a.peekValue((int)attr).type == 3) {
                            c.mTargetString = a.getString(attr);
                            continue block14;
                        }
                        c.mTargetId = a.getResourceId(attr, c.mTargetId);
                        continue block14;
                    }
                    case 2: {
                        c.mFramePosition = a.getInt(attr, c.mFramePosition);
                        continue block14;
                    }
                    case 3: {
                        if (a.peekValue((int)attr).type == 3) {
                            c.mTransitionEasing = a.getString(attr);
                            continue block14;
                        }
                        c.mTransitionEasing = Easing.NAMED_EASING[a.getInteger(attr, 0)];
                        continue block14;
                    }
                    case 10: {
                        c.mPathMotionArc = a.getInt(attr, c.mPathMotionArc);
                        continue block14;
                    }
                    case 4: {
                        c.mCurveFit = a.getInteger(attr, c.mCurveFit);
                        continue block14;
                    }
                    case 5: {
                        c.mDrawPath = a.getInt(attr, c.mDrawPath);
                        continue block14;
                    }
                    case 6: {
                        c.mPercentX = a.getFloat(attr, c.mPercentX);
                        continue block14;
                    }
                    case 7: {
                        c.mPercentY = a.getFloat(attr, c.mPercentY);
                        continue block14;
                    }
                    case 8: {
                        c.mPercentHeight = c.mPercentWidth = a.getFloat(attr, c.mPercentHeight);
                        continue block14;
                    }
                    case 11: {
                        c.mPercentWidth = a.getFloat(attr, c.mPercentWidth);
                        continue block14;
                    }
                    case 12: {
                        c.mPercentHeight = a.getFloat(attr, c.mPercentHeight);
                        continue block14;
                    }
                    case 9: {
                        c.mPositionType = a.getInt(attr, c.mPositionType);
                        continue block14;
                    }
                    default: {
                        Log.e((String)"KeyPosition", (String)("unused attribute 0x" + Integer.toHexString(attr) + "   " + mAttrMap.get(attr)));
                    }
                }
            }
            if (c.mFramePosition == -1) {
                Log.e((String)"KeyPosition", (String)"no frame position");
            }
        }

        static {
            mAttrMap.append(R.styleable.KeyPosition_motionTarget, 1);
            mAttrMap.append(R.styleable.KeyPosition_framePosition, 2);
            mAttrMap.append(R.styleable.KeyPosition_transitionEasing, 3);
            mAttrMap.append(R.styleable.KeyPosition_curveFit, 4);
            mAttrMap.append(R.styleable.KeyPosition_drawPath, 5);
            mAttrMap.append(R.styleable.KeyPosition_percentX, 6);
            mAttrMap.append(R.styleable.KeyPosition_percentY, 7);
            mAttrMap.append(R.styleable.KeyPosition_keyPositionType, 9);
            mAttrMap.append(R.styleable.KeyPosition_sizePercent, 8);
            mAttrMap.append(R.styleable.KeyPosition_percentWidth, 11);
            mAttrMap.append(R.styleable.KeyPosition_percentHeight, 12);
            mAttrMap.append(R.styleable.KeyPosition_pathMotionArc, 10);
        }
    }
}

