/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.helper.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import androidx.constraintlayout.motion.widget.Debug;
import androidx.constraintlayout.motion.widget.KeyAttributes;
import androidx.constraintlayout.motion.widget.KeyPosition;
import androidx.constraintlayout.motion.widget.MotionController;
import androidx.constraintlayout.motion.widget.MotionHelper;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.R;
import java.util.HashMap;

public class MotionEffect
extends MotionHelper {
    public static final String TAG = "FadeMove";
    public static final int AUTO = -1;
    public static final int NORTH = 0;
    public static final int SOUTH = 1;
    public static final int EAST = 2;
    public static final int WEST = 3;
    private float motionEffectAlpha = 0.1f;
    private int motionEffectStart = 49;
    private int motionEffectEnd = 50;
    private int motionEffectTranslationX = 0;
    private int motionEffectTranslationY = 0;
    private boolean motionEffectStrictMove = true;
    private static final int UNSET = -1;
    private int viewTransitionId = -1;
    private int fadeMove = -1;

    public MotionEffect(Context context) {
        super(context);
    }

    public MotionEffect(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MotionEffect(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.MotionEffect);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.MotionEffect_motionEffect_start) {
                    this.motionEffectStart = a.getInt(attr, this.motionEffectStart);
                    this.motionEffectStart = Math.max(Math.min(this.motionEffectStart, 99), 0);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_end) {
                    this.motionEffectEnd = a.getInt(attr, this.motionEffectEnd);
                    this.motionEffectEnd = Math.max(Math.min(this.motionEffectEnd, 99), 0);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_translationX) {
                    this.motionEffectTranslationX = a.getDimensionPixelOffset(attr, this.motionEffectTranslationX);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_translationY) {
                    this.motionEffectTranslationY = a.getDimensionPixelOffset(attr, this.motionEffectTranslationY);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_alpha) {
                    this.motionEffectAlpha = a.getFloat(attr, this.motionEffectAlpha);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_move) {
                    this.fadeMove = a.getInt(attr, this.fadeMove);
                    continue;
                }
                if (attr == R.styleable.MotionEffect_motionEffect_strict) {
                    this.motionEffectStrictMove = a.getBoolean(attr, this.motionEffectStrictMove);
                    continue;
                }
                if (attr != R.styleable.MotionEffect_motionEffect_viewTransition) continue;
                this.viewTransitionId = a.getResourceId(attr, this.viewTransitionId);
            }
            if (this.motionEffectStart == this.motionEffectEnd) {
                if (this.motionEffectStart > 0) {
                    --this.motionEffectStart;
                } else {
                    ++this.motionEffectEnd;
                }
            }
            a.recycle();
        }
    }

    @Override
    public boolean isDecorator() {
        return true;
    }

    @Override
    public void onPreSetup(MotionLayout motionLayout, HashMap<View, MotionController> controllerMap) {
        View[] views = this.getViews((ConstraintLayout)this.getParent());
        if (views == null) {
            Log.v((String)TAG, (String)(Debug.getLoc() + " views = null"));
            return;
        }
        KeyAttributes alpha1 = new KeyAttributes();
        KeyAttributes alpha2 = new KeyAttributes();
        alpha1.setValue("alpha", Float.valueOf(this.motionEffectAlpha));
        alpha2.setValue("alpha", Float.valueOf(this.motionEffectAlpha));
        alpha1.setFramePosition(this.motionEffectStart);
        alpha2.setFramePosition(this.motionEffectEnd);
        KeyPosition stick1 = new KeyPosition();
        stick1.setFramePosition(this.motionEffectStart);
        stick1.setType(0);
        stick1.setValue("percentX", 0);
        stick1.setValue("percentY", 0);
        KeyPosition stick2 = new KeyPosition();
        stick2.setFramePosition(this.motionEffectEnd);
        stick2.setType(0);
        stick2.setValue("percentX", 1);
        stick2.setValue("percentY", 1);
        KeyAttributes translationX1 = null;
        KeyAttributes translationX2 = null;
        if (this.motionEffectTranslationX > 0) {
            translationX1 = new KeyAttributes();
            translationX2 = new KeyAttributes();
            translationX1.setValue("translationX", this.motionEffectTranslationX);
            translationX1.setFramePosition(this.motionEffectEnd);
            translationX2.setValue("translationX", 0);
            translationX2.setFramePosition(this.motionEffectEnd - 1);
        }
        KeyAttributes translationY1 = null;
        KeyAttributes translationY2 = null;
        if (this.motionEffectTranslationY > 0) {
            translationY1 = new KeyAttributes();
            translationY2 = new KeyAttributes();
            translationY1.setValue("translationY", this.motionEffectTranslationY);
            translationY1.setFramePosition(this.motionEffectEnd);
            translationY2.setValue("translationY", 0);
            translationY2.setFramePosition(this.motionEffectEnd - 1);
        }
        int moveDirection = this.fadeMove;
        if (this.fadeMove == -1) {
            int[] direction = new int[4];
            for (int i = 0; i < views.length; ++i) {
                MotionController mc = controllerMap.get(views[i]);
                if (mc == null) continue;
                float x = mc.getFinalX() - mc.getStartX();
                float y = mc.getFinalY() - mc.getStartY();
                if (y < 0.0f) {
                    direction[1] = direction[1] + 1;
                }
                if (y > 0.0f) {
                    direction[0] = direction[0] + 1;
                }
                if (x > 0.0f) {
                    direction[3] = direction[3] + 1;
                }
                if (!(x < 0.0f)) continue;
                direction[2] = direction[2] + 1;
            }
            int max = direction[0];
            moveDirection = 0;
            for (int i = 1; i < 4; ++i) {
                if (max >= direction[i]) continue;
                max = direction[i];
                moveDirection = i;
            }
        }
        for (int i = 0; i < views.length; ++i) {
            MotionController mc = controllerMap.get(views[i]);
            if (mc == null) continue;
            float x = mc.getFinalX() - mc.getStartX();
            float y = mc.getFinalY() - mc.getStartY();
            boolean apply = true;
            if (moveDirection == 0) {
                if (y > 0.0f && (!this.motionEffectStrictMove || x == 0.0f)) {
                    apply = false;
                }
            } else if (moveDirection == 1) {
                if (y < 0.0f && (!this.motionEffectStrictMove || x == 0.0f)) {
                    apply = false;
                }
            } else if (moveDirection == 2) {
                if (x < 0.0f && (!this.motionEffectStrictMove || y == 0.0f)) {
                    apply = false;
                }
            } else if (moveDirection == 3 && x > 0.0f && (!this.motionEffectStrictMove || y == 0.0f)) {
                apply = false;
            }
            if (!apply) continue;
            if (this.viewTransitionId == -1) {
                mc.addKey(alpha1);
                mc.addKey(alpha2);
                mc.addKey(stick1);
                mc.addKey(stick2);
                if (this.motionEffectTranslationX > 0) {
                    mc.addKey(translationX1);
                    mc.addKey(translationX2);
                }
                if (this.motionEffectTranslationY <= 0) continue;
                mc.addKey(translationY1);
                mc.addKey(translationY2);
                continue;
            }
            motionLayout.applyViewTransition(this.viewTransitionId, mc);
        }
    }
}

