/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pair;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.R;
import com.google.android.material.button.MaterialButton;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.CalendarStyle;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DaysOfWeekAdapter;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.Month;
import com.google.android.material.datepicker.MonthAdapter;
import com.google.android.material.datepicker.MonthsPagerAdapter;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.PickerFragment;
import com.google.android.material.datepicker.SmoothCalendarLayoutManager;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.datepicker.YearGridAdapter;
import java.util.Calendar;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class MaterialCalendar<S>
extends PickerFragment<S> {
    private static final String THEME_RES_ID_KEY = "THEME_RES_ID_KEY";
    private static final String GRID_SELECTOR_KEY = "GRID_SELECTOR_KEY";
    private static final String CALENDAR_CONSTRAINTS_KEY = "CALENDAR_CONSTRAINTS_KEY";
    private static final String CURRENT_MONTH_KEY = "CURRENT_MONTH_KEY";
    private static final int SMOOTH_SCROLL_MAX = 3;
    @VisibleForTesting
    static final Object MONTHS_VIEW_GROUP_TAG = "MONTHS_VIEW_GROUP_TAG";
    @VisibleForTesting
    static final Object NAVIGATION_PREV_TAG = "NAVIGATION_PREV_TAG";
    @VisibleForTesting
    static final Object NAVIGATION_NEXT_TAG = "NAVIGATION_NEXT_TAG";
    @VisibleForTesting
    static final Object SELECTOR_TOGGLE_TAG = "SELECTOR_TOGGLE_TAG";
    @StyleRes
    private int themeResId;
    @Nullable
    private DateSelector<S> dateSelector;
    @Nullable
    private CalendarConstraints calendarConstraints;
    @Nullable
    private Month current;
    private CalendarSelector calendarSelector;
    private CalendarStyle calendarStyle;
    private RecyclerView yearSelector;
    private RecyclerView recyclerView;
    private View yearFrame;
    private View dayFrame;

    @NonNull
    public static <T> MaterialCalendar<T> newInstance(@NonNull DateSelector<T> dateSelector, @StyleRes int themeResId, @NonNull CalendarConstraints calendarConstraints) {
        MaterialCalendar materialCalendar = new MaterialCalendar();
        Bundle args = new Bundle();
        args.putInt(THEME_RES_ID_KEY, themeResId);
        args.putParcelable(GRID_SELECTOR_KEY, dateSelector);
        args.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)calendarConstraints);
        args.putParcelable(CURRENT_MONTH_KEY, (Parcelable)calendarConstraints.getOpenAt());
        materialCalendar.setArguments(args);
        return materialCalendar;
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putInt(THEME_RES_ID_KEY, this.themeResId);
        bundle.putParcelable(GRID_SELECTOR_KEY, this.dateSelector);
        bundle.putParcelable(CALENDAR_CONSTRAINTS_KEY, (Parcelable)this.calendarConstraints);
        bundle.putParcelable(CURRENT_MONTH_KEY, (Parcelable)this.current);
    }

    public void onCreate(@Nullable Bundle bundle) {
        super.onCreate(bundle);
        Bundle activeBundle = bundle == null ? this.getArguments() : bundle;
        this.themeResId = activeBundle.getInt(THEME_RES_ID_KEY);
        this.dateSelector = (DateSelector)activeBundle.getParcelable(GRID_SELECTOR_KEY);
        this.calendarConstraints = (CalendarConstraints)activeBundle.getParcelable(CALENDAR_CONSTRAINTS_KEY);
        this.current = (Month)activeBundle.getParcelable(CURRENT_MONTH_KEY);
    }

    @NonNull
    public View onCreateView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle) {
        int orientation;
        int layout2;
        ContextThemeWrapper themedContext = new ContextThemeWrapper(this.getContext(), this.themeResId);
        this.calendarStyle = new CalendarStyle((Context)themedContext);
        LayoutInflater themedInflater = layoutInflater.cloneInContext((Context)themedContext);
        Month earliestMonth = this.calendarConstraints.getStart();
        if (MaterialDatePicker.isFullscreen((Context)themedContext)) {
            layout2 = R.layout.mtrl_calendar_vertical;
            orientation = 1;
        } else {
            layout2 = R.layout.mtrl_calendar_horizontal;
            orientation = 0;
        }
        View root = themedInflater.inflate(layout2, viewGroup, false);
        root.setMinimumHeight(MaterialCalendar.getDialogPickerHeight(this.requireContext()));
        GridView daysHeader = (GridView)root.findViewById(R.id.mtrl_calendar_days_of_week);
        ViewCompat.setAccessibilityDelegate((View)daysHeader, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, @NonNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setCollectionInfo(null);
            }
        });
        daysHeader.setAdapter((ListAdapter)new DaysOfWeekAdapter());
        daysHeader.setNumColumns(earliestMonth.daysInWeek);
        daysHeader.setEnabled(false);
        this.recyclerView = (RecyclerView)root.findViewById(R.id.mtrl_calendar_months);
        SmoothCalendarLayoutManager layoutManager = new SmoothCalendarLayoutManager(this.getContext(), orientation, false){

            protected void calculateExtraLayoutSpace(@NonNull RecyclerView.State state, @NonNull int[] ints) {
                if (orientation == 0) {
                    ints[0] = MaterialCalendar.this.recyclerView.getWidth();
                    ints[1] = MaterialCalendar.this.recyclerView.getWidth();
                } else {
                    ints[0] = MaterialCalendar.this.recyclerView.getHeight();
                    ints[1] = MaterialCalendar.this.recyclerView.getHeight();
                }
            }
        };
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.recyclerView.setTag(MONTHS_VIEW_GROUP_TAG);
        MonthsPagerAdapter monthsPagerAdapter = new MonthsPagerAdapter((Context)themedContext, this.dateSelector, this.calendarConstraints, new OnDayClickListener(){

            @Override
            public void onDayClick(long day) {
                if (MaterialCalendar.this.calendarConstraints.getDateValidator().isValid(day)) {
                    MaterialCalendar.this.dateSelector.select(day);
                    for (OnSelectionChangedListener listener : MaterialCalendar.this.onSelectionChangedListeners) {
                        listener.onSelectionChanged(MaterialCalendar.this.dateSelector.getSelection());
                    }
                    MaterialCalendar.this.recyclerView.getAdapter().notifyDataSetChanged();
                    if (MaterialCalendar.this.yearSelector != null) {
                        MaterialCalendar.this.yearSelector.getAdapter().notifyDataSetChanged();
                    }
                }
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)monthsPagerAdapter);
        int columns = themedContext.getResources().getInteger(R.integer.mtrl_calendar_year_selector_span);
        this.yearSelector = (RecyclerView)root.findViewById(R.id.mtrl_calendar_year_selector_frame);
        if (this.yearSelector != null) {
            this.yearSelector.setHasFixedSize(true);
            this.yearSelector.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)themedContext, columns, 1, false));
            this.yearSelector.setAdapter((RecyclerView.Adapter)new YearGridAdapter(this));
            this.yearSelector.addItemDecoration(this.createItemDecoration());
        }
        if (root.findViewById(R.id.month_navigation_fragment_toggle) != null) {
            this.addActionsToMonthNavigation(root, monthsPagerAdapter);
        }
        if (!MaterialDatePicker.isFullscreen((Context)themedContext)) {
            new PagerSnapHelper().attachToRecyclerView(this.recyclerView);
        }
        this.recyclerView.scrollToPosition(monthsPagerAdapter.getPosition(this.current));
        return root;
    }

    @NonNull
    private RecyclerView.ItemDecoration createItemDecoration() {
        return new RecyclerView.ItemDecoration(){
            private final Calendar startItem = UtcDates.getUtcCalendar();
            private final Calendar endItem = UtcDates.getUtcCalendar();

            public void onDraw(@NonNull Canvas canvas, @NonNull RecyclerView recyclerView, @NonNull RecyclerView.State state) {
                if (!(recyclerView.getAdapter() instanceof YearGridAdapter) || !(recyclerView.getLayoutManager() instanceof GridLayoutManager)) {
                    return;
                }
                YearGridAdapter adapter = (YearGridAdapter)recyclerView.getAdapter();
                GridLayoutManager layoutManager = (GridLayoutManager)recyclerView.getLayoutManager();
                for (Pair<Long, Long> range : MaterialCalendar.this.dateSelector.getSelectedRanges()) {
                    if (range.first == null || range.second == null) continue;
                    this.startItem.setTimeInMillis((Long)range.first);
                    this.endItem.setTimeInMillis((Long)range.second);
                    int firstHighlightPosition = adapter.getPositionForYear(this.startItem.get(1));
                    int lastHighlightPosition = adapter.getPositionForYear(this.endItem.get(1));
                    View firstView = layoutManager.findViewByPosition(firstHighlightPosition);
                    View lastView = layoutManager.findViewByPosition(lastHighlightPosition);
                    int firstRow = firstHighlightPosition / layoutManager.getSpanCount();
                    int lastRow = lastHighlightPosition / layoutManager.getSpanCount();
                    for (int row = firstRow; row <= lastRow; ++row) {
                        int firstPositionInRow = row * layoutManager.getSpanCount();
                        View viewInRow = layoutManager.findViewByPosition(firstPositionInRow);
                        if (viewInRow == null) continue;
                        int top = viewInRow.getTop() + ((MaterialCalendar)MaterialCalendar.this).calendarStyle.year.getTopInset();
                        int bottom = viewInRow.getBottom() - ((MaterialCalendar)MaterialCalendar.this).calendarStyle.year.getBottomInset();
                        int left = row == firstRow ? firstView.getLeft() + firstView.getWidth() / 2 : 0;
                        int right = row == lastRow ? lastView.getLeft() + lastView.getWidth() / 2 : recyclerView.getWidth();
                        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, ((MaterialCalendar)MaterialCalendar.this).calendarStyle.rangeFill);
                    }
                }
            }
        };
    }

    @Nullable
    Month getCurrentMonth() {
        return this.current;
    }

    @Nullable
    CalendarConstraints getCalendarConstraints() {
        return this.calendarConstraints;
    }

    void setCurrentMonth(Month moveTo) {
        MonthsPagerAdapter adapter = (MonthsPagerAdapter)this.recyclerView.getAdapter();
        int moveToPosition = adapter.getPosition(moveTo);
        int distance = moveToPosition - adapter.getPosition(this.current);
        boolean jump = Math.abs(distance) > 3;
        boolean isForward = distance > 0;
        this.current = moveTo;
        if (jump && isForward) {
            this.recyclerView.scrollToPosition(moveToPosition - 3);
            this.postSmoothRecyclerViewScroll(moveToPosition);
        } else if (jump) {
            this.recyclerView.scrollToPosition(moveToPosition + 3);
            this.postSmoothRecyclerViewScroll(moveToPosition);
        } else {
            this.postSmoothRecyclerViewScroll(moveToPosition);
        }
    }

    @Override
    @Nullable
    public DateSelector<S> getDateSelector() {
        return this.dateSelector;
    }

    CalendarStyle getCalendarStyle() {
        return this.calendarStyle;
    }

    @Px
    static int getDayHeight(@NonNull Context context) {
        return context.getResources().getDimensionPixelSize(R.dimen.mtrl_calendar_day_height);
    }

    void setSelector(CalendarSelector selector) {
        this.calendarSelector = selector;
        if (selector == CalendarSelector.YEAR) {
            this.yearSelector.getLayoutManager().scrollToPosition(((YearGridAdapter)this.yearSelector.getAdapter()).getPositionForYear(this.current.year));
            this.yearFrame.setVisibility(0);
            this.dayFrame.setVisibility(8);
        } else if (selector == CalendarSelector.DAY) {
            this.yearFrame.setVisibility(8);
            this.dayFrame.setVisibility(0);
            this.setCurrentMonth(this.current);
        }
    }

    void toggleVisibleSelector() {
        if (this.calendarSelector == CalendarSelector.YEAR) {
            this.setSelector(CalendarSelector.DAY);
        } else if (this.calendarSelector == CalendarSelector.DAY) {
            this.setSelector(CalendarSelector.YEAR);
        }
    }

    private void addActionsToMonthNavigation(@NonNull View root, final @NonNull MonthsPagerAdapter monthsPagerAdapter) {
        final MaterialButton monthDropSelect = (MaterialButton)root.findViewById(R.id.month_navigation_fragment_toggle);
        monthDropSelect.setTag(SELECTOR_TOGGLE_TAG);
        ViewCompat.setAccessibilityDelegate((View)monthDropSelect, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View view, @NonNull AccessibilityNodeInfoCompat accessibilityNodeInfoCompat) {
                super.onInitializeAccessibilityNodeInfo(view, accessibilityNodeInfoCompat);
                accessibilityNodeInfoCompat.setHintText((CharSequence)(MaterialCalendar.this.dayFrame.getVisibility() == 0 ? MaterialCalendar.this.getString(R.string.mtrl_picker_toggle_to_year_selection) : MaterialCalendar.this.getString(R.string.mtrl_picker_toggle_to_day_selection)));
            }
        });
        MaterialButton monthPrev = (MaterialButton)root.findViewById(R.id.month_navigation_previous);
        monthPrev.setTag(NAVIGATION_PREV_TAG);
        MaterialButton monthNext = (MaterialButton)root.findViewById(R.id.month_navigation_next);
        monthNext.setTag(NAVIGATION_NEXT_TAG);
        this.yearFrame = root.findViewById(R.id.mtrl_calendar_year_selector_frame);
        this.dayFrame = root.findViewById(R.id.mtrl_calendar_day_selector_frame);
        this.setSelector(CalendarSelector.DAY);
        monthDropSelect.setText(this.current.getLongName());
        this.recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                int currentItem = dx < 0 ? MaterialCalendar.this.getLayoutManager().findFirstVisibleItemPosition() : MaterialCalendar.this.getLayoutManager().findLastVisibleItemPosition();
                MaterialCalendar.this.current = monthsPagerAdapter.getPageMonth(currentItem);
                monthDropSelect.setText(monthsPagerAdapter.getPageTitle(currentItem));
            }

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                if (newState == 0) {
                    CharSequence announcementText = monthDropSelect.getText();
                    if (Build.VERSION.SDK_INT >= 16) {
                        recyclerView.announceForAccessibility(announcementText);
                    } else {
                        recyclerView.sendAccessibilityEvent(2048);
                    }
                }
            }
        });
        monthDropSelect.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MaterialCalendar.this.toggleVisibleSelector();
            }
        });
        monthNext.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int currentItem = MaterialCalendar.this.getLayoutManager().findFirstVisibleItemPosition();
                if (currentItem + 1 < MaterialCalendar.this.recyclerView.getAdapter().getItemCount()) {
                    MaterialCalendar.this.setCurrentMonth(monthsPagerAdapter.getPageMonth(currentItem + 1));
                }
            }
        });
        monthPrev.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                int currentItem = MaterialCalendar.this.getLayoutManager().findLastVisibleItemPosition();
                if (currentItem - 1 >= 0) {
                    MaterialCalendar.this.setCurrentMonth(monthsPagerAdapter.getPageMonth(currentItem - 1));
                }
            }
        });
    }

    private void postSmoothRecyclerViewScroll(final int position) {
        this.recyclerView.post(new Runnable(){

            @Override
            public void run() {
                MaterialCalendar.this.recyclerView.smoothScrollToPosition(position);
            }
        });
    }

    private static int getDialogPickerHeight(@NonNull Context context) {
        Resources resources = context.getResources();
        int navigationHeight = resources.getDimensionPixelSize(R.dimen.mtrl_calendar_navigation_height) + resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_navigation_top_padding) + resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_navigation_bottom_padding);
        int daysOfWeekHeight = resources.getDimensionPixelSize(R.dimen.mtrl_calendar_days_of_week_height);
        int calendarHeight = MonthAdapter.MAXIMUM_WEEKS * resources.getDimensionPixelSize(R.dimen.mtrl_calendar_day_height) + (MonthAdapter.MAXIMUM_WEEKS - 1) * resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_month_vertical_padding);
        int calendarPadding = resources.getDimensionPixelOffset(R.dimen.mtrl_calendar_bottom_padding);
        return navigationHeight + daysOfWeekHeight + calendarHeight + calendarPadding;
    }

    @NonNull
    LinearLayoutManager getLayoutManager() {
        return (LinearLayoutManager)this.recyclerView.getLayoutManager();
    }

    @Override
    public boolean addOnSelectionChangedListener(@NonNull OnSelectionChangedListener<S> listener) {
        return super.addOnSelectionChangedListener(listener);
    }

    static interface OnDayClickListener {
        public void onDayClick(long var1);
    }

    static enum CalendarSelector {
        DAY,
        YEAR;

    }
}

