/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.util;

import androidx.annotation.RestrictTo;
import java.io.PrintWriter;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class TimeUtils {
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final int HUNDRED_DAY_FIELD_LEN = 19;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final Object sFormatSync = new Object();
    private static char[] sFormatStr = new char[24];

    private static int accumField(int amt, int suffix, boolean always, int zeropad) {
        if (amt > 99 || always && zeropad >= 3) {
            return 3 + suffix;
        }
        if (amt > 9 || always && zeropad >= 2) {
            return 2 + suffix;
        }
        if (always || amt > 0) {
            return 1 + suffix;
        }
        return 0;
    }

    private static int printField(char[] formatStr, int amt, char suffix, int pos, boolean always, int zeropad) {
        if (always || amt > 0) {
            int dig;
            int startPos = pos;
            if (always && zeropad >= 3 || amt > 99) {
                dig = amt / 100;
                formatStr[pos] = (char)(dig + 48);
                ++pos;
                amt -= dig * 100;
            }
            if (always && zeropad >= 2 || amt > 9 || startPos != pos) {
                dig = amt / 10;
                formatStr[pos] = (char)(dig + 48);
                ++pos;
                amt -= dig * 10;
            }
            formatStr[pos] = (char)(amt + 48);
            formatStr[++pos] = suffix;
            ++pos;
        }
        return pos;
    }

    private static int formatDurationLocked(long duration, int fieldLen) {
        int prefix;
        if (sFormatStr.length < fieldLen) {
            sFormatStr = new char[fieldLen];
        }
        char[] formatStr = sFormatStr;
        if (duration == 0L) {
            int pos = 0;
            --fieldLen;
            while (pos < fieldLen) {
                formatStr[pos] = 32;
            }
            formatStr[pos] = 48;
            return pos + 1;
        }
        if (duration > 0L) {
            prefix = 43;
        } else {
            prefix = 45;
            duration = -duration;
        }
        int millis = (int)(duration % 1000L);
        int seconds = (int)Math.floor(duration / 1000L);
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (seconds > 86400) {
            days = seconds / 86400;
            seconds -= days * 86400;
        }
        if (seconds > 3600) {
            hours = seconds / 3600;
            seconds -= hours * 3600;
        }
        if (seconds > 60) {
            minutes = seconds / 60;
            seconds -= minutes * 60;
        }
        int pos = 0;
        if (fieldLen != 0) {
            int myLen;
            myLen += TimeUtils.accumField(millis, 2, true, (myLen += TimeUtils.accumField(seconds, 1, (myLen += TimeUtils.accumField(minutes, 1, (myLen += TimeUtils.accumField(hours, 1, (myLen = TimeUtils.accumField(days, 1, false, 0)) > 0, 2)) > 0, 2)) > 0, 2)) > 0 ? 3 : 0) + 1;
            while (myLen < fieldLen) {
                formatStr[pos] = 32;
                ++pos;
                ++myLen;
            }
        }
        formatStr[pos] = prefix;
        int start = ++pos;
        boolean zeropad = fieldLen != 0;
        pos = TimeUtils.printField(formatStr, days, 'd', pos, false, 0);
        pos = TimeUtils.printField(formatStr, hours, 'h', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printField(formatStr, minutes, 'm', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printField(formatStr, seconds, 's', pos, pos != start, zeropad ? 2 : 0);
        pos = TimeUtils.printField(formatStr, millis, 'm', pos, true, zeropad && pos != start ? 3 : 0);
        formatStr[pos] = 115;
        return pos + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void formatDuration(long duration, StringBuilder builder) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, 0);
            builder.append(sFormatStr, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void formatDuration(long duration, PrintWriter pw, int fieldLen) {
        Object object = sFormatSync;
        synchronized (object) {
            int len = TimeUtils.formatDurationLocked(duration, fieldLen);
            pw.print(new String(sFormatStr, 0, len));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void formatDuration(long duration, PrintWriter pw) {
        TimeUtils.formatDuration(duration, pw, 0);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static void formatDuration(long time, long now, PrintWriter pw) {
        if (time == 0L) {
            pw.print("--");
            return;
        }
        TimeUtils.formatDuration(time - now, pw, 0);
    }

    private TimeUtils() {
    }
}

