/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotificationChannelGroupCompat {
    final String mId;
    CharSequence mName;
    String mDescription;
    private boolean mBlocked;
    private List<NotificationChannelCompat> mChannels = Collections.emptyList();

    NotificationChannelGroupCompat(@NonNull String id) {
        this.mId = Preconditions.checkNotNull(id);
    }

    @RequiresApi(value=28)
    NotificationChannelGroupCompat(@NonNull NotificationChannelGroup group) {
        this(group, Collections.emptyList());
    }

    @RequiresApi(value=26)
    NotificationChannelGroupCompat(@NonNull NotificationChannelGroup group, @NonNull List<NotificationChannel> allChannels) {
        this(group.getId());
        this.mName = group.getName();
        if (Build.VERSION.SDK_INT >= 28) {
            this.mDescription = group.getDescription();
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.mBlocked = group.isBlocked();
            this.mChannels = this.getChannelsCompat(group.getChannels());
        } else {
            this.mChannels = this.getChannelsCompat(allChannels);
        }
    }

    @RequiresApi(value=26)
    private List<NotificationChannelCompat> getChannelsCompat(List<NotificationChannel> channels) {
        ArrayList<NotificationChannelCompat> channelsCompat = new ArrayList<NotificationChannelCompat>();
        for (NotificationChannel channel : channels) {
            if (!this.mId.equals(channel.getGroup())) continue;
            channelsCompat.add(new NotificationChannelCompat(channel));
        }
        return channelsCompat;
    }

    NotificationChannelGroup getNotificationChannelGroup() {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        NotificationChannelGroup group = new NotificationChannelGroup(this.mId, this.mName);
        if (Build.VERSION.SDK_INT >= 28) {
            group.setDescription(this.mDescription);
        }
        return group;
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this.mId).setName(this.mName).setDescription(this.mDescription);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public boolean isBlocked() {
        return this.mBlocked;
    }

    @NonNull
    public List<NotificationChannelCompat> getChannels() {
        return this.mChannels;
    }

    public static class Builder {
        final NotificationChannelGroupCompat mGroup;

        public Builder(@NonNull String id) {
            this.mGroup = new NotificationChannelGroupCompat(id);
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            this.mGroup.mName = name;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String description) {
            this.mGroup.mDescription = description;
            return this;
        }

        @NonNull
        public NotificationChannelGroupCompat build() {
            return this.mGroup;
        }
    }
}

