/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Pools;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class MultiModelLoader<Model, Data>
implements ModelLoader<Model, Data> {
    private final List<ModelLoader<Model, Data>> modelLoaders;
    private final Pools.Pool<List<Throwable>> exceptionListPool;

    MultiModelLoader(@NonNull List<ModelLoader<Model, Data>> modelLoaders, @NonNull Pools.Pool<List<Throwable>> exceptionListPool) {
        this.modelLoaders = modelLoaders;
        this.exceptionListPool = exceptionListPool;
    }

    @Override
    public ModelLoader.LoadData<Data> buildLoadData(@NonNull Model model, int width, int height, @NonNull Options options) {
        Key sourceKey = null;
        int size = this.modelLoaders.size();
        ArrayList fetchers = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            ModelLoader.LoadData<Data> loadData;
            ModelLoader<Model, Data> modelLoader = this.modelLoaders.get(i);
            if (!modelLoader.handles(model) || (loadData = modelLoader.buildLoadData(model, width, height, options)) == null) continue;
            sourceKey = loadData.sourceKey;
            fetchers.add(loadData.fetcher);
        }
        return !fetchers.isEmpty() && sourceKey != null ? new ModelLoader.LoadData(sourceKey, new MultiFetcher(fetchers, this.exceptionListPool)) : null;
    }

    @Override
    public boolean handles(@NonNull Model model) {
        for (ModelLoader<Model, Data> modelLoader : this.modelLoaders) {
            if (!modelLoader.handles(model)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "MultiModelLoader{modelLoaders=" + Arrays.toString(this.modelLoaders.toArray()) + '}';
    }

    static class MultiFetcher<Data>
    implements DataFetcher<Data>,
    DataFetcher.DataCallback<Data> {
        private final List<DataFetcher<Data>> fetchers;
        private final Pools.Pool<List<Throwable>> throwableListPool;
        private int currentIndex;
        private Priority priority;
        private DataFetcher.DataCallback<? super Data> callback;
        @Nullable
        private List<Throwable> exceptions;
        private boolean isCancelled;

        MultiFetcher(@NonNull List<DataFetcher<Data>> fetchers, @NonNull Pools.Pool<List<Throwable>> throwableListPool) {
            this.throwableListPool = throwableListPool;
            Preconditions.checkNotEmpty(fetchers);
            this.fetchers = fetchers;
            this.currentIndex = 0;
        }

        @Override
        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super Data> callback) {
            this.priority = priority;
            this.callback = callback;
            this.exceptions = (List)this.throwableListPool.acquire();
            this.fetchers.get(this.currentIndex).loadData(priority, this);
            if (this.isCancelled) {
                this.cancel();
            }
        }

        @Override
        public void cleanup() {
            if (this.exceptions != null) {
                this.throwableListPool.release(this.exceptions);
            }
            this.exceptions = null;
            for (DataFetcher<Data> fetcher : this.fetchers) {
                fetcher.cleanup();
            }
        }

        @Override
        public void cancel() {
            this.isCancelled = true;
            for (DataFetcher<Data> fetcher : this.fetchers) {
                fetcher.cancel();
            }
        }

        @Override
        @NonNull
        public Class<Data> getDataClass() {
            return this.fetchers.get(0).getDataClass();
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return this.fetchers.get(0).getDataSource();
        }

        @Override
        public void onDataReady(@Nullable Data data) {
            if (data != null) {
                this.callback.onDataReady(data);
            } else {
                this.startNextOrFail();
            }
        }

        @Override
        public void onLoadFailed(@NonNull Exception e) {
            Preconditions.checkNotNull(this.exceptions).add(e);
            this.startNextOrFail();
        }

        private void startNextOrFail() {
            if (this.isCancelled) {
                return;
            }
            if (this.currentIndex < this.fetchers.size() - 1) {
                ++this.currentIndex;
                this.loadData(this.priority, this.callback);
            } else {
                Preconditions.checkNotNull(this.exceptions);
                this.callback.onLoadFailed(new GlideException("Fetch failed", new ArrayList<Throwable>(this.exceptions)));
            }
        }
    }
}

