/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.textfield;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import com.google.android.material.internal.CheckableImageButton;
import com.google.android.material.textfield.TextInputLayout;
import java.util.Arrays;

class IconHelper {
    private IconHelper() {
    }

    static void setIconOnClickListener(@NonNull CheckableImageButton iconView, @Nullable View.OnClickListener onClickListener, @Nullable View.OnLongClickListener onLongClickListener) {
        iconView.setOnClickListener(onClickListener);
        IconHelper.setIconClickable(iconView, onLongClickListener);
    }

    static void setIconOnLongClickListener(@NonNull CheckableImageButton iconView, @Nullable View.OnLongClickListener onLongClickListener) {
        iconView.setOnLongClickListener(onLongClickListener);
        IconHelper.setIconClickable(iconView, onLongClickListener);
    }

    private static void setIconClickable(@NonNull CheckableImageButton iconView, @Nullable View.OnLongClickListener onLongClickListener) {
        boolean iconClickable = ViewCompat.hasOnClickListeners((View)iconView);
        boolean iconLongClickable = onLongClickListener != null;
        boolean iconFocusable = iconClickable || iconLongClickable;
        iconView.setFocusable(iconFocusable);
        iconView.setClickable(iconClickable);
        iconView.setPressable(iconClickable);
        iconView.setLongClickable(iconLongClickable);
        ViewCompat.setImportantForAccessibility((View)iconView, (int)(iconFocusable ? 1 : 2));
    }

    static void applyIconTint(@NonNull TextInputLayout textInputLayout, @NonNull CheckableImageButton iconView, ColorStateList iconTintList, PorterDuff.Mode iconTintMode) {
        Drawable icon = iconView.getDrawable();
        if (icon != null) {
            icon = DrawableCompat.wrap((Drawable)icon).mutate();
            if (iconTintList != null && iconTintList.isStateful()) {
                int color2 = iconTintList.getColorForState(IconHelper.mergeIconState(textInputLayout, iconView), iconTintList.getDefaultColor());
                DrawableCompat.setTintList((Drawable)icon, (ColorStateList)ColorStateList.valueOf((int)color2));
            } else {
                DrawableCompat.setTintList((Drawable)icon, (ColorStateList)iconTintList);
            }
            if (iconTintMode != null) {
                DrawableCompat.setTintMode((Drawable)icon, (PorterDuff.Mode)iconTintMode);
            }
        }
        if (iconView.getDrawable() != icon) {
            iconView.setImageDrawable(icon);
        }
    }

    static void refreshIconDrawableState(@NonNull TextInputLayout textInputLayout, @NonNull CheckableImageButton iconView, ColorStateList colorStateList) {
        Drawable icon = iconView.getDrawable();
        if (iconView.getDrawable() == null || colorStateList == null || !colorStateList.isStateful()) {
            return;
        }
        int color2 = colorStateList.getColorForState(IconHelper.mergeIconState(textInputLayout, iconView), colorStateList.getDefaultColor());
        icon = DrawableCompat.wrap((Drawable)icon).mutate();
        DrawableCompat.setTintList((Drawable)icon, (ColorStateList)ColorStateList.valueOf((int)color2));
        iconView.setImageDrawable(icon);
    }

    private static int[] mergeIconState(@NonNull TextInputLayout textInputLayout, @NonNull CheckableImageButton iconView) {
        int[] textInputStates = textInputLayout.getDrawableState();
        int[] iconStates = iconView.getDrawableState();
        int index = textInputStates.length;
        int[] states = Arrays.copyOf(textInputStates, textInputStates.length + iconStates.length);
        System.arraycopy(iconStates, 0, states, index, iconStates.length);
        return states;
    }
}

