/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.content.ClipData;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.core.content.FileProvider;
import androidx.core.util.AtomicFile;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.TimeUnit;

@Deprecated
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class BrowserServiceFileProvider
extends FileProvider {
    private static final String TAG = "BrowserServiceFP";
    private static final String AUTHORITY_SUFFIX = ".image_provider";
    private static final String CONTENT_SCHEME = "content";
    private static final String FILE_SUB_DIR = "image_provider";
    private static final String FILE_SUB_DIR_NAME = "image_provider_images/";
    private static final String FILE_EXTENSION = ".png";
    private static final String CLIP_DATA_LABEL = "image_provider_uris";
    private static final String LAST_CLEANUP_TIME_KEY = "last_cleanup_time";
    static Object sFileCleanupLock = new Object();

    @UiThread
    @NonNull
    public static ResolvableFuture<Uri> saveBitmap(@NonNull Context context, @NonNull Bitmap bitmap, @NonNull String name, int version) {
        String filename = name + "_" + Integer.toString(version);
        Uri uri = BrowserServiceFileProvider.generateUri(context, filename);
        ResolvableFuture result = ResolvableFuture.create();
        new FileSaveTask(context, filename, bitmap, uri, (ResolvableFuture<Uri>)result).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new String[0]);
        return result;
    }

    private static Uri generateUri(Context context, String filename) {
        String fileName = FILE_SUB_DIR_NAME + filename + FILE_EXTENSION;
        return new Uri.Builder().scheme(CONTENT_SCHEME).authority(context.getPackageName() + AUTHORITY_SUFFIX).path(fileName).build();
    }

    public static void grantReadPermission(@NonNull Intent intent, @Nullable List<Uri> uris, @NonNull Context context) {
        if (uris == null || uris.size() == 0) {
            return;
        }
        ContentResolver resolver = context.getContentResolver();
        intent.addFlags(1);
        ClipData clipData = ClipData.newUri((ContentResolver)resolver, (CharSequence)CLIP_DATA_LABEL, (Uri)uris.get(0));
        for (int i = 1; i < uris.size(); ++i) {
            clipData.addItem(new ClipData.Item(uris.get(i)));
        }
        intent.setClipData(clipData);
    }

    @NonNull
    public static ListenableFuture<Bitmap> loadBitmap(final @NonNull ContentResolver resolver, final @NonNull Uri uri) {
        final ResolvableFuture result = ResolvableFuture.create();
        AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ParcelFileDescriptor descriptor = resolver.openFileDescriptor(uri, "r");
                    if (descriptor == null) {
                        result.setException((Throwable)new FileNotFoundException());
                        return;
                    }
                    FileDescriptor fileDescriptor = descriptor.getFileDescriptor();
                    Bitmap bitmap = BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor);
                    descriptor.close();
                    if (bitmap == null) {
                        result.setException((Throwable)new IOException("File could not be decoded."));
                        return;
                    }
                    result.set((Object)bitmap);
                }
                catch (IOException e) {
                    result.setException((Throwable)e);
                }
            }
        });
        return result;
    }

    private static class FileSaveTask
    extends AsyncTask<String, Void, Void> {
        private final Context mAppContext;
        private final String mFilename;
        private final Bitmap mBitmap;
        private final Uri mFileUri;
        private final ResolvableFuture<Uri> mResultFuture;

        FileSaveTask(Context context, String filename, Bitmap bitmap, Uri fileUri, ResolvableFuture<Uri> resultFuture) {
            this.mAppContext = context.getApplicationContext();
            this.mFilename = filename;
            this.mBitmap = bitmap;
            this.mFileUri = fileUri;
            this.mResultFuture = resultFuture;
        }

        protected Void doInBackground(String ... params) {
            this.saveFileIfNeededBlocking();
            return null;
        }

        protected void onPostExecute(Void result) {
            new FileCleanupTask(this.mAppContext).executeOnExecutor(AsyncTask.SERIAL_EXECUTOR, new Void[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void saveFileIfNeededBlocking() {
            File path = new File(this.mAppContext.getFilesDir(), BrowserServiceFileProvider.FILE_SUB_DIR);
            Object object = sFileCleanupLock;
            synchronized (object) {
                if (!path.exists() && !path.mkdir()) {
                    this.mResultFuture.setException((Throwable)new IOException("Could not create file directory."));
                    return;
                }
                File img = new File(path, this.mFilename + BrowserServiceFileProvider.FILE_EXTENSION);
                if (img.exists()) {
                    this.mResultFuture.set((Object)this.mFileUri);
                } else {
                    this.saveFileBlocking(img);
                }
                img.setLastModified(System.currentTimeMillis());
            }
        }

        private void saveFileBlocking(File img) {
            FileOutputStream fOut = null;
            if (Build.VERSION.SDK_INT >= 22) {
                AtomicFile atomicFile = new AtomicFile(img);
                try {
                    fOut = atomicFile.startWrite();
                    this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
                    fOut.close();
                    atomicFile.finishWrite(fOut);
                    this.mResultFuture.set((Object)this.mFileUri);
                }
                catch (IOException e) {
                    atomicFile.failWrite(fOut);
                    this.mResultFuture.setException((Throwable)e);
                }
            } else {
                try {
                    fOut = new FileOutputStream(img);
                    this.mBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fOut);
                    fOut.close();
                    this.mResultFuture.set((Object)this.mFileUri);
                }
                catch (IOException e) {
                    this.mResultFuture.setException((Throwable)e);
                }
            }
        }
    }

    private static class FileCleanupTask
    extends AsyncTask<Void, Void, Void> {
        private final Context mAppContext;
        private static final long IMAGE_RETENTION_DURATION = TimeUnit.DAYS.toMillis(7L);
        private static final long CLEANUP_REQUIRED_TIME_SPAN = TimeUnit.DAYS.toMillis(7L);
        private static final long DELETION_FAILED_REATTEMPT_DURATION = TimeUnit.DAYS.toMillis(1L);

        FileCleanupTask(Context context) {
            this.mAppContext = context.getApplicationContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Void ... params) {
            SharedPreferences prefs = this.mAppContext.getSharedPreferences(this.mAppContext.getPackageName() + BrowserServiceFileProvider.AUTHORITY_SUFFIX, 0);
            if (!FileCleanupTask.shouldCleanUp(prefs)) {
                return null;
            }
            Object object = sFileCleanupLock;
            synchronized (object) {
                boolean allFilesDeletedSuccessfully = true;
                File path = new File(this.mAppContext.getFilesDir(), BrowserServiceFileProvider.FILE_SUB_DIR);
                if (!path.exists()) {
                    return null;
                }
                File[] files = path.listFiles();
                long retentionDate = System.currentTimeMillis() - IMAGE_RETENTION_DURATION;
                for (File file : files) {
                    long lastModified;
                    if (!FileCleanupTask.isImageFile(file) || (lastModified = file.lastModified()) >= retentionDate || file.delete()) continue;
                    Log.e((String)BrowserServiceFileProvider.TAG, (String)("Fail to delete image: " + file.getAbsoluteFile()));
                    allFilesDeletedSuccessfully = false;
                }
                long lastCleanUpTime = allFilesDeletedSuccessfully ? System.currentTimeMillis() : System.currentTimeMillis() - CLEANUP_REQUIRED_TIME_SPAN + DELETION_FAILED_REATTEMPT_DURATION;
                SharedPreferences.Editor editor = prefs.edit();
                editor.putLong(BrowserServiceFileProvider.LAST_CLEANUP_TIME_KEY, lastCleanUpTime);
                editor.apply();
            }
            return null;
        }

        private static boolean isImageFile(File file) {
            String filename = file.getName();
            return filename.endsWith("..png");
        }

        private static boolean shouldCleanUp(SharedPreferences prefs) {
            long lastCleanup = prefs.getLong(BrowserServiceFileProvider.LAST_CLEANUP_TIME_KEY, System.currentTimeMillis());
            return System.currentTimeMillis() > lastCleanup + CLEANUP_REQUIRED_TIME_SPAN;
        }
    }
}

