#!/usr/bin/perl -w
use strict;

# Naley wywoa z nazwa testowanego programu

my $prog = shift or die "Brak programu do przetestowania";

# Testuje wszystkie kombinacje godziny akceptowanej przez analizator skadniowy.

$| = 1;
# Test 1. Test <godzina>am|pm

print "hh am|pm    ";
for (my $hour = 0; $hour < 12; $hour++) {
  check("$ {hour}am", 60*$hour);
  check("$ {hour}pm", 60*($hour+12));
  print "..";
}

# Test 2. <godzina>am|pm spoza przedziau

check("13am", -1); check("12pm", -1); check("999am", -1);

print "\n";

# Test 3. Sprawdza godziny w formacie hh:mm

my $ans = 0;

print "hh:mm       ";

for (my $hour = 0; $hour < 24; $hour++) {
  print ".";
  for (my $min = "00"; $min lt "60"; $min++) {
    check("$hour:$min", $ans);
    $ans++;
  }
}
print "\n";

# Test 4. Sprawdza godziny w formacie hh:mm am/pm

$ans = 0;
print "hh:mm am/pm ";
for (my $hour = 0; $hour < 12; $hour++) {
  print "..";
  for (my $min = "00"; $min lt "60"; $min++) {
    check("$hour:$ {min}am", $ans);
    check("$hour:$ {min}pm", $ans+12*60);
    $ans++;
  }
}
print "\n";

# I wreszcie kilka nieprawidowych wartoci do sprawdzenia:

check("24:00", -1); check("goofy", -1); check("1:1", -1);
check("1:0023", -1); check("13:34am", -1);

#
# Uruchamia timeparser dla arg1; wyniki testw w arg2:
#
sub check($$) {
  my $time = shift;
  my $expected = shift;
  my $result = `$prog $time 2>/dev/null`;
  my ($got) = split ' ', $result;

  if ($expected < 0) {
    if ($? == 0) {
      die "$prog $time -> test powinien zakoczy si niepowodzeniem, a zwrci returned $got";
    }
  }
  elsif ($got != $expected) {
    die "$prog $time  -> zwrci $got, oczekiwano $expected";
  }
}
  
