#!/usr/bin/perl -w
use strict;

# Z podrozdziau "Jzyki dziedzinowe".
# Analiza skadniowa godizny w formacie:
#
#  time -> hh am/pm   |
#          hh:mm      |
#          hh:mm am/pm
#
# Wywietla liczb minut, ktre upyny od pnocy (w razie bdu zwraca -1).

#START:ans
$_ = shift;

/^(\d\d?)(am|pm)$/        && doTime($1, 0,  $2, 12);
/^(\d\d?):(\d\d)(am|pm)$/ && doTime($1, $2, $3, 12);
/^(\d\d?):(\d\d)$/        && doTime($1, $2,  0, 24);
die "Nieprawidowa godzina $_\n";

#
# doTime(hour, min, ampm, maxHour)
#
sub doTime($$$$) {
  my ($hour, $min, $offset, $maxHour) = @_;
  die "Nieprawidowa godzina: $hour" if ($hour >= $maxHour);
  $hour += 12 if ($offset eq "pm");
  print $hour*60 + $min, " minut od pnocy\n";
  exit(0);
}
#END:ans
