#!/bin/sh

CMD="java dbc.dbc_ex"
failcount=0

expect_okay() {
    if echo "$*" | $CMD #>/dev/null 2>&1
    then
      :
    else
      echo "NIEPOWODZENIE! $*"
      failcount=`expr $failcount + 1`
    fi
}

expect_fail() {
    if echo "$*" | $CMD >/dev/null 2>&1
    then
      echo "NIEPOWODZENIE! (zgodnie z oczekiwaniami): $*"
      failcount=`expr $failcount + 1`
    fi
}

report() {
  if [ $failcount -gt 0 ]
  then
    echo -e "\n\n*** TESTY $failcount ZAKOCZONE NIEPOWODZENIEM\n"
    exit 1 # Na wypadek, gdyby ten kod by czci wikszej caoci
  else
    exit 0 # Na wypadek, gdyby ten kod by czci wikszej caoci
  fi
}

#
# Rozpoczyna testy
#

expect_okay F123456789876543210E # Powinien przej
expect_fail F5    # Bd, za dua szybko
expect_fail 1     # Bd, pusty
expect_fail F10E1 # Bd, pusty
expect_fail F1238 # Bd, pomija
expect_okay FE    # Nigdy nie wcza
expect_fail F1E   # Oprnia w czasie dziaania
expect_okay F10E  # Powinno by prawidowe
report            # Raportuje wyniki
