package dbc;

import java.util.Enumeration;
import java.util.Vector;

/**
  * Prosty przykad wstawiania na licie dla podrozdziau "Projektowanie kontraktowe".
  * Wystarczy zmiana kilku wierszy, aby otrzyma list cykliczn.
  */


// START: fig
/**
  * @invariant forall Node n in elements() |
  *    n.prev() != null
  *      implies
  *         n.value().compareTo(n.prev().value()) > 0
  */

public class dbc_list {

  /**
    * @pre contains(aNode) == false
    * @post contains(aNode) == true
    */
  public void insertNode(final Node aNode) {
    // ...
// END: fig

    if (myFirst == null) {
      myFirst = aNode;
      myLast = aNode;
      aNode.setNext(null);
      aNode.setPrev(null);
    }
    else {
      myLast.setNext(aNode);
      aNode.setNext(null);
      aNode.setPrev(myLast);
      myLast = aNode;
     }
  }

  /**
    * Zwraca pierwszy wze na licie.
    */
  public Node first() {
    return myFirst;
  }

  /**
    * Zwraca ostatni wze na licie.
    */
  public Node last() {
    return myLast;
  }

  /**
    * Sprawdza, czy lista zawiera dany wze.
    */
  public boolean contains(final Node aNode) {
    Node itr = myFirst;
    if (itr == null)
      return false;
    boolean result = false;
    while (true) {
      if (itr.value().equals(aNode.value())) {
        result = true;
        break;
      }
      if (itr == myLast) {
        break;
      }
      itr = itr.next();
    }
    return result;
  }

  /**
    * Zwraca list w formie wyliczenia.
    */
  public Enumeration elements() {
    Vector v = new Vector();
    Node itr = myFirst;
    if (itr != null) {
      while (true) {
        v.addElement(itr);
        if (itr == myLast) {
          break;
        }
        itr = itr.next();
      }
    }
    return v.elements();
  }

  /**
    * Wywietla list w formie acucha.
    */
  public String toString() {
    StringBuffer ret = new StringBuffer();
    ret.append("\ndbc_list: Pierwszy = " + myFirst.value() + 
                           " Ostatni = " + myLast.value() + "\n");
    Node itr = myFirst;
    if (itr != null) {
      while (true) {
        ret.append("\t" + itr.toString() + "\n");
        if (itr == myLast) {
          break;
        }
        itr = itr.next();
      }
    }
    return ret.toString();
  }

  /**
    * Sprawdza asercj
    */
  public static void check(boolean aCondition) {
    if (!aCondition) {
      System.out.println("==== Asercja zakoczona niepowodzeniem ====");
      Thread.dumpStack();
      System.exit(1);
    }
  }

  private Node myFirst;
  private Node myLast;

  /**
    * Testuje klas.
    */
  public static void main(String[] args) { 
    dbc_list list = new dbc_list();
    Node a = new Node("TestA"); list.insertNode(a);
    Node b = new Node("TestB"); list.insertNode(b);
    Node c = new Node("TestC"); list.insertNode(c);
    check(a != b);
    check(b != c);
    check(a.next() == b);
    check(b.next() == c);
    check(c.prev() == b);
    check(b.prev() == a);
    System.err.println ("Test dbc_list zaliczony.");
  }

}
