/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
package com.pragprog.util;

import java.io.*;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;
import java.awt.*;
import java.awt.event.*;
import com.pragprog.util.Assert;

/**
  * Ten plik zawiera szereg krótkich przykładów w Javie, które
  * nie zasługują na osobne klasy.
  */

public class Misc {

  FileInputStream ipstream;

  public void open_passwd() throws FileNotFoundException {

    // Ten kod może zgłosić wyjątek FileNotFoundException...
    ipstream = new FileInputStream("/etc/passwd");
    
    // ...
  }

  public boolean open_user_file(String name) 
    throws FileNotFoundException {
    
    File f = new File(name);
    
    if (!f.exists()) {
      return false;
    }
    
    ipstream = new FileInputStream(f);
    return true;
  }

  public static void loopinv() {
    int arr[] = new int[10];

    int m = arr[0];   // w przykładzie założono arr.length > 0
    int i = 1;
    
    // Niezmiennik pętli: m = max(arr[0:i-1])
    while (i < arr.length) {
      m = Math.max(m, arr[i]);
      i = i + 1;
    }
  }

  public static void debug(String s) throws IOException {
    FileWriter fw = new FileWriter("debug.log", true);
    fw.write(s);
    fw.flush();
    fw.close();
  }

  public void testListener() {
    Button b = new Button("Przykład");
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
        System.err.println ("Wciśnięty przycisk");
      }
    });
  }

  public void testStringTokenizer() {
    StringTokenizer st1 = new StringTokenizer("to jest test");
    StringTokenizer st2 = new StringTokenizer("ten test będzie działać");

    while (st1.hasMoreTokens() && st2.hasMoreTokens()) {
      System.out.println(st1.nextToken());
      System.out.println(st2.nextToken());
    }
  }

  //
  // Z podrozdziału „Prawo Demeter”.
  //

  // 
  // Kilka sztucznych definicji tak, aby przykłady się skompilowały...
  //
  public class Misc {
    public String printFormat() { return "$0.00"; }
  }

  public class BankAccount {
    public void printBalance() {};
    public Money getBalance() {
      return null;
    }
  }

  public void printToScreen(String s) {};

  public void showBalance(BankAccount acct) {
    Money amt = acct.getBalance();
    printToScreen(amt.printFormat());
  }

  public class Other {
  void showBalance(BankAccount b) {
    b.printBalance();
  }
  }

  //
  // Definicje–atrapy dla przykładu Colada.
  //
  public class Blender {
    public void addIngredients(Enumeration e) {};
  }

  public class Colada {
    private Blender myBlender;
    private Vector myStuff;

    public Colada() {
      myBlender = new Blender();
      myStuff = new Vector();
    }
    private void doSomething() {
      myBlender.addIngredients(myStuff.elements());
    }
  }

  //
  // Oprzyrządowanie testowe.
  //
  public final static void main(String args[]) {
    try {
      debug("Ciąg testowy\n");
    } catch (Exception e) {
      System.out.println("Przechwycony wyjątek: " + e.getMessage());
    }
  }
}

