#!/usr/bin/perl -w
#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
use strict;

# Z podrozdziału "Generatory kodu",
# sposób użycia:  cg_base <language>  <flatfile
#  gdzie <language> identyfikuje wywoływany generator kodu
#  <language>_cg.pl

my $lang = shift or die "Nie ma takiego języka";
$lang .= "_cg.pm";

require "$lang" or die "Nie można załadować języka $lang";

# Odczytaj i sparsuj plik

my $name;

while (<>) {
  chomp;
  if    (/^\s*$/)     { CG::blankLine(); }
  elsif (/^\#(.*)/)   { CG::comment($1); }
  elsif (/^M\s*(.+)/) { CG::startMsg($1); $name = $1; }
  elsif (/^E/)        { CG::endMsg($name); }
  elsif (/^F\s*(\w+)\s+(\w+)$/)
                      { CG::simpleType($1,$2); }
  elsif (/^F\s*(\w+)\s+(\w+)\[(\d+)\]$/)
                      { CG::arrayType($1,$2,$3); }
  else {
    die "Nieprawidłowy wiersz: $_";
  }
}


