#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
defmodule DictReader do
  def read_dict do
    "/usr/share/dict/words"
    |> File.read!()
    |> String.split()
    |> Enum.filter(fn word -> String.length(word) >= 3 end)
    |> Enum.reduce(%{}, &add_to_dict/2)
  end

  def signature_of(word) when is_binary(word) do
    word
    |> String.codepoints()
    |> signature_of()
  end

  def signature_of(word) when is_list(word) do
    word
    |> Enum.sort()
    |> Enum.join()
  end

  defp add_to_dict(word, result) do
    sig = signature_of(word)
    Map.update(result, sig, [ word ], &[ word | &1 ])
  end
end


defmodule Dictionary do

  @dict %{} #DictReader.read_dict

  defdelegate signature_of(word), to: DictReader

  def lookup_by_signature(sig) when is_binary(sig) do
    @dict[sig]
  end
end
