#---
# Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
# wydanej w tłumaczeniu przez Wydawnictwo Helion.
# Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
# kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
# Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
# Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
#---
#
# Z podrozdziału "Jak zrównoważyć zasoby", ilustruje złe równoważenie zasobów
#

def assert(c, msg="nieznany błąd")
  raise "Assertion failed: #{msg}" unless c
end

require 'bigdecimal'

class Customer
  attr :balance
  attr :name
  attr_reader :customer_file # tylko do asercji

  def initialize(name)
    @customer_file = nil
    @balance       = BigDecimal("0")
    @name          = name
    File.open(@name + ".rec", "w") {|f| f.puts @balance} # Pusty plik tylko do demonstracji
  end

  def read_customer
    @customer_file = File.open(@name + ".rec", "r+")
    @balance       = BigDecimal(@customer_file.gets)
  end

  def write_customer
    @customer_file.rewind
    @customer_file.puts @balance.to_s
    @customer_file.close
  end

  def update_customer(transaction_amount)
    read_customer
    @balance = @balance.add(transaction_amount,2)
    write_customer
  end
end

c = Customer.new("andy")
c.update_customer(1000.00)
assert(c.balance == 1000.00, "saldo powinno być zgodne")
assert(c.customer_file.closed?, "plik powinien być zamknięty")


class Customer
  def update_customer(transaction_amount)
    read_customer
    if (transaction_amount >= 0.00)
      @balance = @balance.add(transaction_amount,2)
      write_customer
    end
  end
end

c=Customer.new("andy")
c.update_customer(-1000.00)
assert(!c.customer_file.closed?, "plik powinien być otwarty (potwierdzenie błędu)")


class Customer
  def update_customer(transaction_amount)
    read_customer
    if (transaction_amount >= 0.00)
      @balance += BigDecimal(transaction_amount, 2)
      write_customer
    else
      @customer_file.close # Zły pomysł!
    end
  end
end

c = Customer.new("andy")
c.update_customer(-1000.00)
assert(c.customer_file.closed?, "plik powinien być zamknięty (potwierdzenie naprawy)")
