/***
 * Fragment z książki „Pragmatyczny programista. Wydanie jubileuszowe”,
 * wydanej w tłumaczeniu przez Wydawnictwo Helion.
 * Ten kod jest chroniony prawem autorskim. Nie może być używany do tworzenia materiałów szkoleniowych,
 * kursów, książek, artykułów, itp. W przypadku wątpliwości, skontaktuj się z nami.
 * Nie dajemy gwarancji, że ten kod będzie przydatny do jakiegokolwiek celu.
 * Więcej informacji na temat książki znajdziesz pod adresem  http://www.pragmaticprogrammer.com/titles/tpp20.
***/
/**
  * Z podrozdziału „Kod łatwy do testowania”,
  * ten przykład wymaga frameworka JUnit w wersji 2.1 lub nowszej.
  */

import java.util.Enumeration;
import java.util.Vector;
import junit.framework.*;

public class JUnitExample extends TestCase {
  
  
  public class DblPair {
    public double num;
    public double expected;
    public DblPair(double a, double b) {
      num = a;
      expected = b;
    }
    public double getNum() {
      return num;
    }
    public double getExpected() {
      return expected;
    }
  }

  private double mySqrt(final double x) { 
    if (x < 0) {
      throw new RuntimeException("Arg musi być dodatni");
    }
    return Math.sqrt(x); 
  }
  protected Vector testData = new Vector();
  private static final double epsilon = 0.0001;

  public JUnitExample(final String name) {
    super(name);
  }

  protected void setUp() {
    // Ładowanie danych testowych...
    testData.addElement(new DblPair(-4.0,0.0));
    testData.addElement(new DblPair(0.0,0.0));
    testData.addElement(new DblPair(64.0,8.0));
    testData.addElement(new DblPair(Double.MAX_VALUE,
                                    1.3407807929942597E154));
  }

  public void testValue(double num, double expected) {
    double result = 0.0;

    try {                    // Możemy zgłosić
      result = mySqrt(num);  // wyjątek zgodny z warunkiem wstępnym
    }
    catch (Throwable e) {
      if (num < 0.0)         // Jeśli input jest < 0, to
        return;              // oczekujemy 
      else                   // wyjątku, w przeciwnym razie
        assert(false);       // wymuszamy zakończenie testu z niepowodzeniem
    }

    assert(Math.abs(expected-result) < epsilon*expected);
  }


  public void testMySqrt() {
    double num, expected, result = 0.0;

    Enumeration enum = testData.elements();
    while (enum.hasMoreElements()) {
      DblPair p = (DblPair)enum.nextElement();
      num       = p.getNum();
      expected  = p.getExpected();
      testValue(num, expected);
    }
  }

  public static Test suite() {
      TestSuite suite= new TestSuite();
      suite.addTest(new JUnitExample("testMySqrt"));
      return suite;
  }
}

