using System;
using Marketplace.EventSourcing;

namespace Marketplace.Ads.Domain.ClassifiedAds
{
    public class PictureSize : Value<PictureSize>
    {
        public PictureSize(int width, int height)
        {
            if (width <= 0)
                throw new ArgumentOutOfRangeException(
                    nameof(width),
                    "Szeroko zdjcia musi by liczb dodatni"
                );

            if (height <= 0)
                throw new ArgumentOutOfRangeException(
                    nameof(height),
                    "Wysoko zdjcia musi by liczb dodatni"
                );

            Width = width;
            Height = height;
        }

        internal PictureSize() { }
        public int Width { get; internal set; }
        public int Height { get; internal set; }
    }
}