using System;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Serilog;

namespace Marketplace.Infrastructure
{
    public static class RequestHandler
    {
        public static async Task<IActionResult> HandleCommand<T>(
            T request, Func<T, Task> handler, ILogger log)
        {
            try
            {
                log.Debug("Obsuga dania HTTP typu {type}", typeof(T).Name);
                await handler(request);
                return new OkResult();
            }
            catch (Exception e)
            {
                log.Error(e, "Bd podczas obsugi polecenia");
                return new BadRequestObjectResult(new
                {
                    error = e.Message, stackTrace = e.StackTrace
                });
            }
        }
        
        public static IActionResult HandleQuery<TModel>(
            Func<TModel> query, ILogger log)
        {
            try
            {
                return new OkObjectResult(query());
            }
            catch (Exception e)
            {
                log.Error(e, "Bd podczas obsugi zapytania");
                return new BadRequestObjectResult(new
                {
                    error = e.Message, stackTrace = e.StackTrace
                });
            }
        }
    }
}