import { Component } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';

@Component({
  selector: 'app-search',
  template: `
    <form [formGroup]="searchForm" (ngSubmit)="search()">
      <input type="text" placeholder="Nazwa użytkownika" formControlName="searchText">
      <button type="submit" [disabled]="searchForm.invalid">Szukaj</button>
    </form>
  `
})
export class SearchComponent {

  get searchText() {
    return this.searchForm.controls.searchText;
  }
  searchForm = new FormGroup({
    searchText: new FormControl('', Validators.required)
  });

  search() {
    if(this.searchForm.valid) {
      console.log('Twoje wyszukiwanie to: ' + this.searchText.value)
    }
  }
}
