import { HttpClientModule } from '@angular/common/http';
import { NgModule } from '@angular/core';
import { BrowserModule } from '@angular/platform-browser';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { CartComponent } from './cart/cart.component';
import { ProductsModule } from './products/products.module';
import { PageNotFoundComponent } from './page-not-found/page-not-found.component';
import { AuthModule } from './auth/auth.module';
import { ReactiveFormsModule } from '@angular/forms';
import { CommonModule } from '@angular/common';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { MatButtonModule } from '@angular/material/button';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonToggleModule} from '@angular/material/button-toggle';
import { MatToolbarModule } from '@angular/material/toolbar';
import { MatListModule} from '@angular/material/list';
import { MapComponent } from './map/map.component';
//import { PlayerComponent } from './player/player.component';


@NgModule({
  declarations: [
     AppComponent,
     CartComponent,
     PageNotFoundComponent,
     MapComponent,
    // YouTubePlayerModule
  ],
  imports: [
     BrowserModule,
     ProductsModule,
     AppRoutingModule,
     HttpClientModule,
     AuthModule,
     ReactiveFormsModule,
     CommonModule,
     BrowserAnimationsModule,
     MatButtonModule,
     MatIconModule,
     MatButtonToggleModule,
     MatToolbarModule,
     MatListModule

  ],
  providers: [],
  bootstrap: [AppComponent]
})

export class AppModule { }
