﻿# Testowanie irand() w generowaniu liuczb pseudolosowych
# Stosowanie:
#	awk [-v LOW=nnn] [-v HIGH=nnn] [-v MAXTEST=nnn] [-v SEED=nnn] -f test-good-irand.awk

BEGIN {
    MAXDEF = 1024 * 1024

    MAXTEST = (MAXTEST == "") ? MAXDEF : int(MAXTEST)
    MAXTEST = (MAXTEST > 0) ? MAXTEST : MAXDEF

    LOW = (LOW == "") ? 0 : int(LOW)

    HIGH = (HIGH == "") ? 10 : int(HIGH)
    HIGH = (HIGH <= LOW) ? (LOW + 1) : HIGH

    # Inicjalizacja generatora
    if (SEED == "")
	srand()
    else
	srand(SEED)

    # Próbkowanie generatora
    for (k = 1; k <= MAXTEST; ++k)
	count[irand(LOW, HIGH)]++
    chisq = 0

    # Zliczanie wyników
    n = 0
    for (k in count)
	n++

    degrees_of_freedom = HIGH - LOW
    if (n != (1 + degrees_of_freedom))
    {
	print "\nBŁĄD: stopnie swobody nie odpowiadają oczekiwanej liczbie\n"
	n = 1 + degrees_of_freedom
    }

    print "Wartości count[]"
    for (k = LOW; k <= HIGH; ++k)
    {
	if (k in count)
    	    printf("\t[%d] = %d\n", k, count[k])
    }
    print ""

    # Obliczanie miary rozkładu chi-kwadrat
    chisq = 0
    e = MAXTEST / n
    for (k in count)
        chisq += (e - count[k])^2 / e

    # Wypisanie wyników
    printf("Test irand(%d,%d) z %d próbek\n", LOW, HIGH, MAXTEST)
    printf("n = %d\n", n)
    printf("stopnie swobody = %d\n", HIGH - LOW)
    printf("rozkład chi kwadrat = %.5f\n", chisq)
}

function irand(low, high,     n)
{
    # Zwraca liczbę całkowitą pseudolosową n taką, że low <= n <= high

    # Wymuszenie całkowitych granic zakresu
    low = int(low)
    high = int(high)

    # Kontrola poprawności uporządkowania argumentów wywołania
    if (low >= high)
	return (low)

    # Wyszukanie wartości z zadanego zakresu
    do
        n = low + int(rand() * (high + 1 - low))
    while ((n < low) || (high < n))

    return (n)
}
