﻿#! /usr/local/bin/nawk -f
#! /bin/awk -f
BEGIN {
	entities["TeX"]	= "TeX"
	entities["LaTeX"]	= "LaTeX"
	entities["BIBTeX"]	= "BIBTeX"
	entities["vellip"]	= "\n\t.\n\t.\n\t.\n"
	entities["hellip"]	= "..."
	entities["lowbar"]	= "_"
	entities["frac18 "]	= "1/8"
	entities["frac38 "]	= "3/8"
	entities["frac58 "]	= "5/8"
	entities["frac78 "]	= "7/8"
	entities["frac13 "]	= "1/3"
	entities["frac23 "]	= "2/3"
	entities["frac15 "]	= "1/5"
	entities["frac25 "]	= "2/5"
	entities["frac35 "]	= "3/5"
	entities["frac45 "]	= "4/5"
	entities["frac16 "]	= "1/6"
	entities["frac56 "]	= "5/6"
	entities["frac112"]	= "1/12"
	entities["frac116"]	= "1/16"
	entities["lcub"]	= "{"
	entities["rcub"]	= "}"
	entities["AElig"]	= "AE"
	entities["Aacute"]	= "'A"
	entities["Acirc"]	= "^A"
	entities["Agr"]	= "*A"
	entities["Agrave"]	= "`A"
	entities["Aring"]	= "oA"
	entities["Atilde"]	= "~A"
	entities["Auml"]	= ":A"
	entities["Bgr"]	= "*B"
	entities["Ccedil"]	= ",C"
	entities["Dagger"]	= "t"
	entities["Delta"]	= "*D"
	entities["Dgr"]	= "*D"
	entities["Dot"]	= "ad"
	entities["EEgr"]	= "*Y"
	entities["ETH"]	= "-D"
	entities["Eacute"]	= "'E"
	entities["Ecirc"]	= "^E"
	entities["Egr"]	= "*E"
	entities["Egrave"]	= "`E"
	entities["Euml"]	= ":E"
	entities["Gamma"]	= "Gamma"
	entities["Ggr"]	= "*G"
	entities["IJlig"]	= "IJ"
	entities["Iacute"]	= "'I"
	entities["Icirc"]	= "^I"
	entities["Ifr"]	= "Im"
	entities["Igr"]	= "*I"
	entities["Igrave"]	= "`I"
	entities["Iuml"]	= ":I"
	entities["KHgr"]	= "*X"
	entities["Kgr"]	= "*K"
	entities["Lambda"]	= "Lamda"
	entities["Lgr"]	= "Lamda"
	entities["Mgr"]	= "*M"
	entities["Ngr"]	= "*N"
	entities["Ntilde"]	= "~N"
	entities["OElig"]	= "OE"
	entities["OHgr"]	= "*W"
	entities["Oacute"]	= "'O"
	entities["Ocirc"]	= "^O"
	entities["Ogr"]	= "*O"
	entities["Ograve"]	= "`O"
	entities["Omega"]	= "Omega"
	entities["Oslash"]	= "/O"
	entities["Otilde"]	= "~O"
	entities["Ouml"]	= ":O"
	entities["PHgr"]	= "*F"
	entities["PSgr"]	= "*Q"
	entities["Pgr"]	= "*P"
	entities["Phi"]	= "*F"
	entities["Pi"]	= "*P"
	entities["Prime"]	= "sd"
	entities["Psi"]	= "*Q"
	entities["Rfr"]	= "Re"
	entities["Rgr"]	= "*R"
	entities["Scaron"]	= "vS"
	entities["Sgr"]	= "*S"
	entities["Sigma"]	= "*S"
	entities["THORN"]	= "TP"
	entities["THgr"]	= "*H"
	entities["Tgr"]	= "*T"
	entities["Theta"]	= "*H"
	entities["Uacute"]	= "'U"
	entities["Ucirc"]	= "^U"
	entities["Ugr"]	= "*U"
	entities["Ugrave"]	= "`U"
	entities["Uuml"]	= ":U"
	entities["Xgr"]	= "*C"
	entities["Xi"]	= "*C"
	entities["Yacute"]	= "Yacute"
	entities["Yuml"]	= ":Y"
	entities["Zcaron"]	= "vZ"
	entities["Zgr"]	= "*Z"
	entities["aacute"]	= "'a"
	entities["acirc"]	= "^a"
	entities["acute"]	= "aa"
	entities["aelig"]	= "ae"
	entities["agr"]	= "*a"
	entities["agrave"]	= "`a"
	entities["aleph"]	= "aleph"
	entities["alpha"]	= "alpha"
	entities["amp"]	= "&"
	entities["and"]	= "AND"
	entities["ang"]	= "/_"
	entities["ape"]	= "~="
	entities["aring"]	= "oa"
	entities["ast"]	= "*"
	entities["atilde"]	= "~a"
	entities["auml"]	= ":a"
	entities["bepsi"]	= "st"
	entities["beta"]	= "beta"
	entities["bgr"]	= "*b"
	entities["breve"]	= "ab"
	entities["brvbar"]	= "bb"
	entities["bsol"]	= "\\"
	entities["bull"]	= "bu"
	entities["cap"]	= "ca"
	entities["caron"]	= "ah"
	entities["ccedil"]	= ",c"
	entities["cedil"]	= "ac"
	entities["cent"]	= "ct"
	entities["chi"]	= "*x"
	entities["cir"]	= "ci"
	entities["circ"]	= "ha"
	entities["clubs"]	= "CL"
	entities["colon"]	= ":"
	entities["comma"]	= ","
	entities["commat"]	= "at"
	entities["cong"]	= "=~"
	entities["copy"]	= "co"
	entities["cup"]	= "cu"
	entities["curren"]	= "$"
	entities["dArr"]	= "dA"
	entities["dagger"]	= "t"
	entities["darr"]	= "da"
	entities["deg"]	= "de"
	entities["delta"]	= "*d"
	entities["dgr"]	= "*d"
	entities["diam"]	= "lz"
	entities["diams"]	= "DI"
	entities["die"]	= "die"
	entities["divide"]	= "di"
	entities["dollar"]	= "$"
	entities["dot"]	= "a."
	entities["dtri"]	= "gr"
	entities["eacute"]	= "'e"
	entities["ecirc"]	= "^e"
	entities["eegr"]	= "*y"
	entities["egr"]	= "*e"
	entities["egrave"]	= "`e"
	entities["empty"]	= "es"
	entities["emsp"]	= " "
	entities["emsp13"]	= " "
	entities["emsp14"]	= " "
	entities["ensp"]	= " "
	entities["nwsp"]	= " "
	entities["equals"]	= "="
	entities["equiv"]	= "=="
	entities["eta"]	= "*y"
	entities["eth"]	= "Sd"
	entities["euml"]	= ":e"
	entities["excl"]	= "!"
	entities["exist"]	= "exists"
	entities["ffilig"]	= "Fi"
	entities["fflig"]	= "ff"
	entities["ffllig"]	= "Fl"
	entities["filig"]	= "fi"
	entities["fllig"]	= "fl"
	entities["forall"]	= "for all"
	entities["frac12"]	= "1/2"
	entities["frac14"]	= "1/4"
	entities["frac24"]	= "2/4"
	entities["frac34"]	= "3/4"
	entities["gamma"]	= "gamma"
	entities["ge"]	= ">="
	entities["ggr"]	= "*g"
	entities["grave"]	= "`"
	entities["gt"]	= ">"
	entities["hArr"]	= "hA"
	entities["hairsp"]	= ""
	entities["harr"]	= "<>"
	entities["hearts"]	= "hearts"
	entities["hyphen"]	= "-"
	entities["fhyph"]	= "-"
	entities["iacute"]	= "'i"
	entities["icirc"]	= "^i"
	entities["iexcl"]	= "r!"
	entities["igr"]	= "*i"
	entities["igrave"]	= "`i"
	entities["ijlig"]	= "ij"
	entities["infin"]	= "if"
	entities["inodot"]	= ".i"
	entities["iota"]	= "*i"
	entities["iquest"]	= "r?"
	entities["isin"]	= "mo"
	entities["iuml"]	= ":i"
	entities["kappa"]	= "*k"
	entities["kgr"]	= "*k"
	entities["khgr"]	= "*x"
	entities["lArr"]	= "lA"
	entities["lambda"]	= "lambda"
	entities["langle"]	= "langle"
	entities["laquo"]	= "Fo"
	entities["larr"]	= "<-"
	entities["lbrace"]	= "lC"
	entities["lbrack"]	= "lB"
	entities["ldquo"]	= "``"
	entities["le"]	= "<="
	entities["lgr"]	= "*l"
	entities["lowast"]	= "**"
	entities["lpar"]	= "("
	entities["lsquo"]	= "`"
	entities["lt"]	= "<"
	entities["macr"]	= "a-"
	entities["mdash"]	= "---"
	entities["mgr"]	= "*m"
	entities["middot"]	= "md"
	entities["minus"]	= "-"
	entities["mu"]	= "mu"
	entities["nbsp"]	= " "
	entities["ndash"]	= "--"
	entities["ne"]	= "!="
	entities["ngr"]	= "*n"
	entities["not"]	= "no"
	entities["notin"]	= "nm"
	entities["ntilde"]	= "~n"
	entities["nu"]	= "nu"
	entities["num"]	= "#"
	entities["numsp"]	= " "
	entities["oacute"]	= "'o"
	entities["ocirc"]	= "^o"
	entities["oelig"]	= "oe"
	entities["ogon"]	= "ho"
	entities["ogr"]	= "*o"
	entities["ograve"]	= "`o"
	entities["ohgr"]	= "*w"
	entities["ohm"]	= "*W"
	entities["omega"]	= "*w"
	entities["oplus"]	= "c+"
	entities["or"]	= "OR"
	entities["ordf"]	= "Of"
	entities["ordm"]	= "Om"
	entities["oslash"]	= "/o"
	entities["otilde"]	= "~o"
	entities["otimes"]	= "c*"
	entities["ouml"]	= ":o"
	entities["para"]	= "ps"
	entities["part"]	= "pd"
	entities["percnt"]	= "%"
	entities["period"]	= "."
	entities["permil"]	= "%0"
	entities["perp"]	= "pp"
	entities["pgr"]	= "*p"
	entities["phgr"]	= "*f"
	entities["phis"]	= "+p"
	entities["phiv"]	= "+f"
	entities["pi"]	= "*p"
	entities["plus"]	= "+"
	entities["plusmn"]	= "+-"
	entities["pound"]	= "#"
	entities["prime"]	= "fm"
	entities["prop"]	= "pt"
	entities["psgr"]	= "*q"
	entities["psi"]	= "*q"
	entities["quest"]	= "?"
	entities["quot"]	= "\""
	entities["rArr"]	= "->"
	entities["rangle"]	= "ra"
	entities["raquo"]	= "Fc"
	entities["rarr"]	= "->"
	entities["rbrace"]	= "}"
	entities["rbrack"]	= "]"
	entities["rdquo"]	= "''"
	entities["reg"]	= "rg"
	entities["rgr"]	= "*r"
	entities["rho"]	= "*r"
	entities["ring"]	= "ao"
	entities["rpar"]	= ")"
	entities["rsquo"]	= "'"
	entities["scaron"]	= "vs"
	entities["sect"]	= "sc"
	entities["semi"]	= ";"
	entities["sfgr"]	= "ts"
	entities["sgr"]	= "*s"
	entities["sigma"]	= "*s"
	entities["sim"]	= "ap"
	entities["sol"]	= "sl"
	entities["spades"]	= "SP"
	entities["squ"]	= "sq"
	entities["squote"]	= "'"
	entities["sub"]	= "sb"
	entities["sube"]	= "ib"
	entities["sup    "]	= "sp"
	entities["sup1"]	= "S1"
	entities["sup2"]	= "S2"
	entities["sup3"]	= "S3"
	entities["supe"]	= "ip"
	entities["szlig"]	= "ss"
	entities["tau"]	= "*t"
	entities["tgr"]	= "*t"
	entities["there4"]	= "tf"
	entities["thetav"]	= "+h"
	entities["thgr"]	= "*h"
	entities["thinsp"]	= ""
	entities["thorn"]	= "Tp"
	entities["tilde"]	= "ti"
	entities["times"]	= "x"
	entities["trade"]	= "tm"
	entities["uArr"]	= "uA"
	entities["uacute"]	= "'u"
	entities["uarr"]	= "ua"
	entities["ucirc"]	= "^u"
	entities["ugr"]	= "*u"
	entities["ugrave"]	= "`u"
	entities["uml"]	= "uml"
	entities["uuml"]	= ":u"
	entities["verbar"]	= "or"
	entities["weierp"]	= "wp"
	entities["xgr"]	= "*c"
	entities["xi"]	= "*c"
	entities["yacute"]	= "yacute"
	entities["yen"]	= "Ye"
	entities["yuml"]	= ":y"
	entities["zcaron"]	= "vz"
	entities["zeta"]	= "*z"
	entities["zgr"]	= "*z"

	# from vi book
	entities["cursor"]	= ""
	entities["vis-space"]	= " "

	specials["<?lb>"] = " "
	specials["<keycap>"] = " "

	RS = "<[^>]+>"
	entity = "&[^;&]+;"
}

{
	if (match($0, entity) == 0) {
		printf "%s", $0
		special_case()
		next
	}
	# jest dopasowanie
	text = $0
	out = ""
	do {
		front = substr(text, 1, RSTART - 1)
		object = substr(text, RSTART+1, RLENGTH-2)	# wycięcie & oraz ;
		rest = substr(text, RSTART + RLENGTH)
		if (object in entities)
			replace = entities[object]
		else
			replace = object
		out = out front replace
		text = rest
	} while (match(text, entity) != 0)
	if (length(text) > 0)
		out = out text
	printf("%s", out)
	special_case()
}

function special_case(	rt, ref)
{
	# kilka przypadków specjalnych
	rt = tolower(RT)
	if (rt in specials) {
		printf "%s", specials[rt]
	} else if (rt ~ /<xref/) {
		ref = gensub(/<xref.*"(.*)">/,"\\1", 1, rt)
		ref = toupper(ref)
		printf "%s", ref
	}
}
