#! /bin/sh -
# Wczytuje jeden albo wicej plikw HTML (SGML, XML) wskazanych w wywoaniu
# i wyszukuje w pliku wiersze zwierajce oznaczenie <znacznik>sowo</znacznik>;
# na standardowym wyjciu wypisuje list rozdzielanych znakami tabulacji rekordw postaci:
#
#	licznik sowo znacznik nazwa pliku
#
# posortowan wedug rosncych wartoci licznika i znacznika.
# 
# Stosownaie:
#	znaczniki pliki-xml

for f in "$@"
do
  cat "$f" |
    sed -e 's#systemitem *role="url"#URL#g' -e 's#/systemitem#/URL#' |
      tr ' (){}[]' '\n\n\n\n\n\n\n' |
        egrep '>[^<>]+</' |
	  awk -F'[<>]' -v FILE="$f" '{printf("%-31s\t%-15s\t%s\n", $3, $2, FILE)}' |
	    sort |
	      uniq -c |
	        sort -k2,2 -k3,3 |
		  awk '{
			  print ($2 == Last) ? ($0 " <----") : $0
			  Last = $2
		       }'
done
