<?php
/*
Plugin Name: Ustawienia Smashing
Plugin URI: http://tdh.me/wordpress/smashing-settings/
Description: Prosta wtyczka ustawień.
Author: Thord Daniel Hedengren
Author URI: http://tdh.me/
*/

// Inicjacja smashings_settingsdemo_init() w panelu administracyjnym
add_action( 'admin_init', 'smashings_settingsdemo_init' );

// Dodaje funkcję strony ustawień do menu
add_action( 'admin_menu', 'smashings_settingsdemo_add_page' );

// Funkcja ustawień
function smashings_settingsdemo_init(){
	register_setting( 'smashings_settingsdemo_options', 'smashings_sample', 'smashings_settingsdemo_validate' );
}

// Dodanie do menu
function smashings_settingsdemo_add_page() {
	add_options_page( 'Przykład ustawień Smashing', 'Ustawienia Smashing', 'manage_options', 'smashings_settingsdemo', 'smashings_settingsdemo_do_page' );
}

// Rzeczywiste dodanie strony ustawień
function smashings_settingsdemo_do_page() {
	?>
	<div class="wrap">
		<h2>Ustawienia Smashing</h2>
		<p>To jest nasza strona ustawień.</p>
		<form method="post" action="options.php">
			<?php settings_fields( 'smashings_settingsdemo_options' ); ?>
			<?php $options = get_option( 'smashings_sample' ); ?>
			<table class="form-table">
				<tr valign="top"><th scope="row">Pole tekstowe</th>
					<td>
						<input type="text" name="smashings_sample[sometext]" value="<?php echo $options['sometext']; ?>" />
					</td>
				</tr>
				<tr valign="top"><th scope="row">Pole wyboru</th>
					<td>
						<input name="smashings_sample[option1]" type="checkbox" value="1" <?php checked('1', $options['option1']); ?> />
					</td>
				</tr>
			</table>
			<p class="submit">
				<input type="submit" class="button-primary" value="<?php _e('Zapisz zmiany') ?>" />
			</p>
		</form>
	</div>
<?php }

// Sprawdzenie danych w tablicy.
function smashings_settingsdemo_validate($input) {

	// W polu tekstowym nie może być kodu HTML
	$input['sometext'] =  wp_filter_nohtml_kses($input['sometext']);
	
	// Czy pole wyboru jest zaznaczone
	$input['option1'] = ( $input['option1'] == 1 ? 1 : 0 );

	return $input;

}
?>