package com.wordz.adapters.db;

import com.github.database.rider.core.api.configuration.DBUnit;
import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.ExpectedDataSet;
import com.github.database.rider.junit5.api.DBRider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import javax.sql.DataSource;
import java.sql.SQLException;

@DBRider
@DBUnit(caseSensitiveTableNames = true,
        caseInsensitiveStrategy= Orthography.LOWERCASE)
public class DatabaseMigrationPostgresTest {

    private DataSource dataSource;

    @SuppressWarnings("unused") // Używane przez framework DBRider
    private final ConnectionHolder connectionHolder = () -> dataSource.getConnection();
    private DatabaseMigration migration;

    @BeforeEach
    void setupConnection() {
        this.dataSource = new PostgresTestDataSource();
        this.migration = new DatabaseMigration(dataSource);
    }

    /**
     * Test wspierający.
     * Pozwala na zapoznanie się z biblioteką Flyway.
     *
     * Istnieją pewne obszary wymagające poprawy:
     * 1. Testowany jest tylko jeden przypadek — pusta baza.
     * 2. Test jest destruktywny. Dane zostaną utracone w środowisku uruchomienia testu.
     * 3. Użycie @ExpectedDataSet może być zbyt dokładnym testem.
     *
     * Pierwsza kwestia jest dość prosta. Należy dodać testy, aby wymusić odpowiednie 
     * zachowanie powiązane z tabelą flyway_schema_history oraz obecnością innych tabel.
     * 
     * Usuwanie danych należy uwzględnić jako część szerszego planu testowego.
     * W tej sytuacji kasowanie danych jest wygodne. Byłoby jednak nieakceptowalne, 
     * gdybyśmy testowali na produkcji albo korzystali ze współdzielonej 
     * przez wielu programistów bazy danych lub środowiska testowego. 
     * Takie środowiska istnieją po to, aby przechowywać istotne ilości danych 
     * pseudoprodukcyjnych i wymagają odpowiedniego zarządzania. 
     * Użycie automatyzacji w takich środowiskach jest warte zachodu. 
     * Być może należałoby je utworzyć jako obrazy Dockera lub używając języka 
     * Terraform albo podobnego, aby tworzyć skrypty konfigurujące połączenie
     * i zapisujące dane. Wszystkie te zadania stanowią podstawowy zakres odpowiedzialności 
     * utrzymania operacji oraz inżynierii danych. To samo w sobie stanowi istotny temat, 
     * ale nie wchodzi w zakres testów.
     *
     * Problem zbyt sztywnego testowania wiąże się z ogólną strategią stosowania 
     * środowisk testowych. Sprawdzamy dokładną listę słów. W rzeczywistości 
     * moglibyśmy zapisywać je w jakiś inny sposób, co z pewnością wpływa 
     * na optymalny sposób testowania.
     * 
     * W związku z tym cały test oznaczony jest jako @Disabled (nieaktywny). 
     * Nie będzie uruchamiany w ramach zestawu testów. Za każdym razem musi 
     * zostać celowo uruchomiony przez programistę.
     *
     * Pamiętaj, że użytkownik musi mieć odpowiednie uprawnienia do danej tabeli, aby wykonać operację DROP.
     * Oznacza to, że musi być właścicielem (twórcą) tej tabeli lub mieć uprawnienia do tworzenia tabel
     * w obrębie danej bazy danych.
     */
    @Disabled
    @Test
    @ExpectedDataSet("adapters/data/initialSchema.json")
    public void createsSchemaOnEmptyDatabase() throws SQLException {
        dropTables();

        migration.execute();
    }

    private void dropTables() throws SQLException {
        dropTableIfExists("flyway_schema_history");
        dropTableIfExists("word");
        dropTableIfExists("game");
    }

    private void dropTableIfExists(String tableName) throws SQLException {
        var stmt = dataSource.getConnection().createStatement();
        stmt.execute("drop table if exists " + tableName);
    }
}
