package com.wordz.adapters.db;

import com.github.database.rider.core.api.configuration.DBUnit;
import com.github.database.rider.core.api.configuration.Orthography;
import com.github.database.rider.core.api.connection.ConnectionHolder;
import com.github.database.rider.core.api.dataset.DataSet;
import com.github.database.rider.junit5.api.DBRider;
import com.wordz.domain.WordRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

import javax.sql.DataSource;

import static org.assertj.core.api.Assertions.assertThat;

@DBRider
@DBUnit(caseSensitiveTableNames = true,
        caseInsensitiveStrategy= Orthography.LOWERCASE)
public class WordRepositoryPostgresTest {

    private DataSource dataSource;

    @SuppressWarnings("unused") // Używane przez framework DBRider
    private final ConnectionHolder connectionHolder = () -> dataSource.getConnection();

    /**
     * Ta metoda konfiguruje połączenie z testową bazą danych.
     * Ponieważ nie tworzy przy tej okazji żadnych danych testowych,
     * moglibyśmy rozważyć użycie adnotacji @BeforeAll, żeby przeprowadzić
     * tę samą operację jednokrotnie, a nie dla każdego przypadku testowego.
     */
    @BeforeEach
    void setupConnection() {
        this.dataSource = new PostgresTestDataSource();
    }

    @Test
    @DataSet("adapters/data/wordTable.json")
    public void fetchesWord()  {
        WordRepository repository = new WordRepositoryPostgres(dataSource);

        String actual = repository.fetchWordByNumber(27);

        assertThat(actual).isEqualTo("SERIA");
    }

    @Test
    @DataSet("adapters/data/threeWords.json")
    public void returnsHighestWordNumber()  {
        WordRepository repository = new WordRepositoryPostgres(dataSource);

        int actual = repository.highestWordNumber();

        assertThat(actual).isEqualTo(3);
    }
}
