package com.wordz.domain;

import org.junit.jupiter.api.Test;

import static org.assertj.core.api.Assertions.assertThat;

class PlayerTest {

    @Test
    void twoAreEqual() {
        Player a = new Player("to-samo-imię-oznacza-równość");
        Player b = new Player("to-samo-imię-oznacza-równość");

        assertThat(a).isEqualTo(b);
    }

    @Test
    void twoAreNotEqual() {
        Player a = new Player("to-samo-imię-oznacza-równość");
        Player b = new Player("różne-imię-oznacza-nierówność");

        assertThat(a).isNotEqualTo(b);
    }

    @Test
    void equalHaveSameHashcode() {
        Player a = new Player("to-samo-imię-oznacza-równość");
        Player b = new Player("to-samo-imię-oznacza-równość");

        assertThat(a.hashCode()).isEqualTo(b.hashCode());
    }
}
