
/**
 * Zależności modułu.
 */

var fs = require('fs')
  , stdin = process.stdin
  , stdout = process.stdout

/**
 * Odczytaj bieżący katalog.
 */

fs.readdir(__dirname, function (err, files) {
  console.log('');

  if (!files.length) {
    return console.log('    \033[31m Brak plików do wyświetlenia!\033[39m\n');
  }

  console.log('   Wybierz plik lub katalog, który chcesz zobaczyć\n');

  // wywoływane dla każdego pliku w katalogu
  function file(i) {
    var filename = files[i];

    fs.stat(__dirname + '/' + filename, function (err, stat) {
      if (stat.isDirectory()) {
        console.log('     '+i+'   \033[36m' + filename + '/\033[39m');
      } else {
        console.log('     '+i+'   \033[90m' + filename + '\033[39m');
      }

      if (++i == files.length) {
        read();
      } else {
        file(i);
      }
    });
  }

  // pobierz dane od użytkownika po pokazaniu plików
  function read () {
    console.log('');
    stdout.write('   \033[33mWprowadź swój wybór: \033[39m');

    stdin.resume();
    stdin.setEncoding('utf8');
    stdin.on('data', option);
  }

  // wywoływne z opcją podaną przez użytkownika
  function option (data) {
    if (!files[Number(data)]) {
      stdout.write('   \033[31mWprowadź swój wybór: \033[39m');
    } else {
      stdin.removeListener('data', option);
    }
  }

  // zacznij od pierwszego pliku
  file(0);
});
