
/**
 * Zależności modułu.
 */

var express = require('express')
  , mysql = require('mysql')
  , config = require('./config')

/**
 * Utwórz aplikację.
 */

app = express.createServer();

/**
 * Metody pośredniczące.
 */

app.use(express.bodyParser());

/**
 * Skonfiguruj aplikację.
 */

app.set('view engine', 'jade');
app.set('views', __dirname + '/views');

/**
 * Trasa domyślna
 */

app.get('/', function (req, res, next) {
  db.query('SELECT id, title, description FROM item', function (err, results) {
    res.render('index', { items: results });
  });
});

/**
 * Trasa dodawania produktu.
 */

app.post('/create', function (req, res, next) {
  db.query('INSERT INTO item SET title = ?, description = ?',
  [req.body.title, req.body.description], function (err, info) {
    if (err) return next(err);
    console.log(' - produkt dodany z id %s', info.insertId);
    res.redirect('/');
  });
});

/**
 * Trasa produktu.
 */

app.get('/item/:id', function (req, res, next) {
  function getItem () {
    db.query('SELECT id, title, description FROM item WHERE id = ? LIMIT 1',
    [req.params.id], function (err, results) {
      if (err) return next(err);
      if (!results[0]) return res.send(404);
      fn(results[0]);
    });
  }

  function getReviews (item_id) {
    db.query('SELECT text, stars FROM review WHERE item_id = ?',
    [item_id], function (err, results) {
      if (err) return next(err);
      fn(results);
    });
  }

  getItem(function (item) {
    getReviews(item.id, function (reviews) {
      res.render('item', { item: item, reviews: reviews });
    });
  });
});

/**
 * Trasa dodawania opinii o produkcie.
 */

app.post('/item/:id/review', function (req, res, next) {
  db.query('INSERT INTO review SET item_id = ?, stars = ?, text = ?',
  [req.params.id, req.body.stars, req.body.text], function (err, info) {
    if (err) return next(err);
    console.log(' - opinia dodana z id %s', info.insertId);
    res.redirect('/item/' + req.params.id);
  });
});

/**
 * Połącz się z MySQL
 */

var db = mysql.createClient(config);

/**
 * Nasłuchuj.
 */

app.listen(3000, function () {
  console.log(' - nasłuchuję na http://*:3000');
});
