
/**
 * Zależności modułu.
 */

var express = require('express')
  , mongodb = require('mongodb')

/**
 * Konfiguracja aplikacji.
 */

app = express.createServer()

/**
 * Metody pośredniczące.
 */

app.use(express.bodyParser());
app.use(express.cookieParser());
app.use(express.session({ secret: 'moj sekret' }));

/**
 * Określ opcje widoku.
 */

app.set('view engine', 'jade');

/**
 * Domyślna trasa
 */

app.get('/', function (req, res) {
  res.render('index', { authenticated: false });
});

/**
 * Trasa logowania
 */

app.get('/login', function (req, res) {
  res.render('login');
});

/**
 * Trasa rejestracji
 */

app.get('/signup', function (req, res) {
  res.render('signup');
});

/**
 * Połącz się z bazą danych.
 */

var server = new mongodb.Server('127.0.0.1', 27017)
new mongodb.Db('my-website', server).open(function (err, client) {
  // nie pozwól na uruchomienie aplikacji, jeśli pojawił się błąd
  if (err) throw err;

  console.log('\033[96m  + \033[39m połączono z mongodb');

  // ustaw skróty do kolekcji
  app.users = new mongodb.Collection(client, 'users');

  // nasłuchuj
  app.listen(3000, function () {
    console.log('\033[96m  + \033[39m aplikacja nasłuchuje na porcie *:3000');
  });
});
