/**
 * Zależności modułu.
 */

var express = require('express')
  , sio = require('socket.io')

/**
 * Utwórz aplikację.
 */

app = express.createServer(
    express.bodyParser()
  , express.static('public')
);

/**
 * Nasłuchuj.
 */

app.listen(3000);

var io = sio.listen(app);

io.sockets.on('connection', function (socket) {
  socket.on('join', function (name) {
    socket.nickname = name;
    socket.broadcast.emit('announcement', name + ' wchodzi na czat.');
  });

  socket.on('text', function (msg, fn) {
    socket.broadcast.emit('text', socket.nickname, msg);
    fn(Date.now());
  });
});
