
/**
 * Wymagane moduły.
 */

var express = require('express')
  , search = require('./search')

/**
 * Utwórz aplikację.
 */

var app = express.createServer();

/**
 * Konfiguracja
 */

app.set('view engine', 'ejs');
app.set('views', __dirname + '/views');
app.set('view options', { layout: false });

/**
 * Trasy
 */

app.get('/', function (req, res) {
  res.render('index');
});

app.get('/search', function (req, res, next) {
  search(req.query.q, function (err, tweets) {
    if (err) return next(err);
    res.render('search', { statuses: tweets, search: req.query.q });
  });
});

/**
 * Nasłuchuj
 */

app.listen(3000);
