
/**
 * Zależności modułu.
 */

var net = require('net')

/**
 * Przechowuj liczbę aktywnych połączeń
 */

var count = 0
  , users = {}

/**
 * Utwórz serwer.
 */

var server = net.createServer(function (conn) {
  conn.write(
      '\n > witaj na \033[92mczacie node\033[39m!'
    + '\n > ' + count + ' innych osób jest teraz połączonych.'
    + '\n > wprowadź swój pseudonim i naciśnij enter: '
  );
  count++;

  conn.setEncoding('utf8');

  // pseudonim dla bieżącego połączenia
  var nickname;

  function broadcast (msg, exceptMyself) {
    for (var i in users) {
      if (!exceptMyself || i != nickname) {
        users[i].write(msg);
      }
    }
  }

  conn.on('data', function (data) {
    // usuń znak "enter"
    data = data.replace('\r\n', '');

    // pierwszym oczekiwanym elementem danych jest pseudonim
    if (!nickname) {
      if (users[data]) {
        conn.write('\033[93m > pseudonim jest już używany. spróbuj ponownie:\033[39m ');
        return;
      } else {
        nickname = data;
        users[nickname] = conn;

        for (var i in users) {
          users[i].write('\033[90m > ' + nickname + ' wchodzi do pokoju\033[39m\n');
        }
      }
    } else {
      // w każdym innym przypadku jest to komunikat czatu
      broadcast('\033[96m > ' + nickname + ':\033[39m ' + data + '\n', true);
    }
  });

  conn.on('close', function () {
    count--;
    delete users[nickname];
    broadcast('\033[90m > ' + nickname + ' opuszcza pokój\033[39m\n');
  });
});

/**
 * Nasłuchuj.
 */

server.listen(3000, function () {
  console.log('\033[96m   serwer nasłuchuje na *:3000\033[39m');
});
