
/**
 * Zależności modułu.
 */

var express = require('express')
  , mysql = require('mysql')
  , config = require('./config')

/**
 * Utwórz aplikację.
 */

app = express.createServer();

/**
 * Metody pośredniczące.
 */

app.use(express.bodyParser());

/**
 * Skonfiguruj aplikację.
 */

app.set('view engine', 'jade');
app.set('views', __dirname + '/views');

/**
 * Trasa domyślna
 */

app.get('/', function (req, res, next) {
  res.render('index', { items: [] });
});

/**
 * Trasa dodawania produktu.
 */

app.post('/create', function (req, res, next) {
  db.query('INSERT INTO item SET title = ?, description = ?',
  [req.body.title, req.body.description], function (err, info) {
    if (err) return next(err);
    console.log(' - produkt dodany z id %s', info.insertId);
    res.redirect('/');
  });
});

/**
 * Trasa produktu.
 */

app.get('/item/:id', function (req, res, next) {
  res.render('item');
});

/**
 * Trasa dodawania opinii o produkcie.
 */

app.post('/item/:id/review', function (req, res, next) {
  db.query('INSERT INTO review SET item_id = ?, stars = ?, text = ?',
  [req.params.id, req.body.stars, req.body.text], function (err, info) {
    if (err) return next(err);
    console.log(' - opinia dodana z id %s', info.insertId);
    res.redirect('/item/' + req.params.id);
  });
});

/**
 * Połącz się z MySQL
 */

var db = mysql.createClient(config);

/**
 * Nasłuchuj.
 */

app.listen(3000, function () {
  console.log(' - nasłuchuję na http://*:3000');
});
