
/**
 * Metoda pośrednicząca czasu żądania.
 *
 * Opcje:
 *   - `time` (`Number`): number of ms after which we log (100)
 *
 * @param {Object} options
 * @api public
 */

module.exports = function (opts) {

  var time = opts.time || 100;

  return function (req, res, next) {
    var timer = setTimeout(function () {
      console.log(
          '\033[90m%s %s\033[39m \033[91mtrwa zbyt długo!\033[39m'
        , req.method
        , req.url
      );
    }, time);

    var end = res.end;
    res.end = function (chunk, encoding) {
      res.end = end;
      res.end(chunk, encoding);
      clearTimeout(timer);
    };

    next();
  };

};
