
/**
 * Zależności modułu.
 */

var express = require('express')
  , mongodb = require('mongodb')

/**
 * Konfiguracja aplikacji.
 */

app = express.createServer()

/**
 * Metody pośredniczące.
 */

app.use(express.bodyParser());
app.use(express.cookieParser());
app.use(express.session({ secret: 'moj sekret' }));

/**
 * Określ opcje widoku.
 */

app.set('view engine', 'jade');

/**
 * Domyślna trasa
 */

app.get('/', function (req, res) {
  res.render('index', { authenticated: false });
});

/**
 * Trasa logowania
 */

app.get('/login', function (req, res) {
  res.render('login');
});

/**
 * Trasa rejestracji
 */

app.get('/signup', function (req, res) {
  res.render('signup');
});

/**
 * Nasłuchuj
 */

app.listen(3000, function () {
  console.log('\033[96m  + \033[39m aplikacja nasłuchuje na porcie *:3000');
});
