
var express = require('express')
  , wsio = require('websocket.io')
  , http = require('http')

/**
 * Utwórz aplikację Express.
 */

var app = express();
var server = http.createServer(app);

/**
 * Przyłącz serwer WebSocket.
 */

var ws = wsio.attach(server);

/**
 * Obsłuż kod
 */

app.use(express.static('public'))

/**
 * Nasłuchiwanie połączeń
 */

var positions = {}
  , total = 0

ws.on('connection', function (socket) {
  // nadajemy gniazdu identyfikator
  socket.id = ++total;

  // wysyłamy pozycje wszystkich pozostałych
  socket.send(JSON.stringify(positions));

  socket.on('message', function (msg) {
    try {
      var pos = JSON.parse(msg);
    } catch (e) {
      return;
    }

    positions[socket.id] = pos;
    broadcast(JSON.stringify({ type: 'position', pos: pos, id: socket.id }));
  });

  socket.on('close', function () {
    delete positions[socket.id];
    broadcast(JSON.stringify({ type: 'disconnect', id: socket.id }));
  });

  function broadcast (msg) {
    for (var i = 0, l = ws.clients.length; i < l; i++) {
      // unikamy wysłania komunikatu do gniazda, które rozgłasza
      if (ws.clients[i] && socket.id != ws.clients[i].id) {
        // wywołanie 'send' dla wszystkich pozostałych klientów
        ws.clients[i].send(msg);
      }
    }
  }
});

/**
 * Nasłuchuj
 */

server.listen(3000);
