'use strict';

var util = require('util');
var path = require('path');
var express = require('express');
var router = express.Router();
var notes = require(process.env.NOTES_MODEL ? path.join('..', process.env.NOTES_MODEL) : '../models/notes-memory');

const log   = require('debug')('notes:router-notes');
const error = require('debug')('notes:error');

// Dodawanie (tworzenie) notatki
router.get('/add', (req, res, next) => {
    res.render('noteedit', {
        title: "Dodawanie notatki",
        docreate: true,
        notekey: "",
        note: undefined,
        breadcrumbs: [
            { href: '/', text: 'Strona główna' },
            { active: true, text: "Dodawanie notatki" }
        ],
        hideAddNote: true
    });
});

// Zapisywanie (aktualizowanie) notatki
router.post('/save', (req, res, next) => {
    var p;
    if (req.body.docreate === "create") {
        p = notes.create(req.body.notekey,
                req.body.title, req.body.body);
    } else {
        p = notes.update(req.body.notekey,
                req.body.title, req.body.body);
    }
    p.then(note => {
        res.redirect('/notes/view?key='+ req.body.notekey);
    })
    .catch(err => { next(err); });
});

// Wczytywanie notatki
router.get('/view', (req, res, next) => {
    notes.read(req.query.key)
    .then(note => {
        res.render('noteview', {
            title: note ? note.title : "",
            notekey: req.query.key,
            note: note,
            breadcrumbs: [
                { href: '/', text: 'Strona główna' },
                { active: true, text: note.title }
            ]
        });
    })
    .catch(err => { next(err); });
});

// Edytowanie (aktualizowanie) notatki
router.get('/edit', (req, res, next) => {
    notes.read(req.query.key)
    .then(note => {
        res.render('noteedit', {
            title: note ? ("Edytuj " + note.title) : "Dodaj notatkę",
            docreate: false,
            notekey: req.query.key,
            note: note,
            hideAddNote: true,
            breadcrumbs: [
                { href: '/', text: 'Strona główna' },
                { active: true, text: note.title }
            ]
        });
    })
    .catch(err => { next(err); });
});

// Pytanie o usunięcie notatki
router.get('/destroy', (req, res, next) => {
    notes.read(req.query.key)
    .then(note => {
        res.render('notedestroy', {
            title: note ? note.title : "",
            notekey: req.query.key,
            note: note,
            breadcrumbs: [
                { href: '/', text: 'Strona główna' },
                { active: true, text: 'Usuwanie notatki' }
            ]
        });
    })
    .catch(err => { next(err); });
});

// Rzeczywiste usuwanie notatki
router.post('/destroy/confirm', (req, res, next) => {
    notes.destroy(req.body.notekey)
    .then(() => { res.redirect('/'); })
    .catch(err => { next(err); });
});

module.exports = router;
