
var http = require('http');
var util = require('util');
var url  = require('url');
var os   = require('os');

var server = http.createServer();
server.on('request', (req, res) => {
    var requrl = url.parse(req.url, true);
    if (requrl.pathname === '/') {
        res.writeHead(200, {'Content-Type': 'text/html'});
        /*
         * Stara technika - sprzed wersji Node.js 4.2.0
         *
        res.end(
          ["<html><head><title>Witaj, świecie!</title></head>",
           "<body><h1>Witaj, świecie!</h1>",
           "<p><a href='/osinfo'>Informacje o systemie</a></p>",
           "</body></html>"]
           .join('\n')
        );
         */
        res.end(
`<html><head><title>Witaj, świecie!</title></head>
<body><h1>Witaj, świecie!</h1>
<p><a href='/osinfo'>Informacje o systemie</a></p>
</body></html>`);
    } else if (requrl.pathname === "/osinfo") {
        res.writeHead(200, {'Content-Type': 'text/html'});
        /*
         * Stara technika - sprzed wersji Node.js 4.2.0
         *
        res.end(
            ["<html><head><title>Informacje o systemie</title></head>",
             "<body><h1>Informacje o systemie</h1>",
             "<table>",
             "<tr><th>Katalog TMP</th><td>{tmpdir}</td></tr>",
             "<tr><th>Nazwa hosta</th><td>{hostname}</td></tr>",
             "<tr><th>Typ systemu</th><td>{ostype} {osplat} {osarch} {osrelease}</td></tr>",
             "<tr><th>Czas działania</th><td>{uptime} {loadavg}</td></tr>",
             "<tr><th>Pamięć</th><td>W sumie: {totalmem} wolna:{freemem}</td></tr>",
             "<tr><th>Procesory</th><td><pre>{cpudata}</pre></td></tr>",
             "<tr><th>Sieć</th><td><pre>{netdata}</pre></td></tr>",
             "</table>",
             "</body></html>"]
            .join('\n')
            .replace("{tmpdir}", os.tmpDir())
            .replace("{hostname}", os.hostname())
            .replace("{ostype}", os.type())
            .replace("{osplat}", os.platform())
            .replace("{osarch}", os.arch())
            .replace("{osrelease}", os.release())
            .replace("{uptime}", os.uptime())
            .replace("{loadavg}", util.inspect(os.loadavg()))
            .replace("{totalmem}", os.totalmem())
            .replace("{freemem}", os.freemem())
            .replace("{cpudata}", util.inspect(os.cpus()))
            .replace("{netdata}", util.inspect(os.networkInterfaces()))
        );
         */
        res.end(
`<html><head><title>Informacje o systemie</title></head>
<body><h1>Informacje o systemie</h1>
<table>
<tr><th>Katalog TMP</th><td>${os.tmpDir()}</td></tr>
<tr><th>Nazwa hosta</th><td>${os.hostname()}</td></tr>
<tr><th>Typ systemu</th><td>${os.type()} ${os.platform()} ${os.arch()} ${os.release()}</td></tr>
<tr><th>Czas działania</th><td>${os.uptime()} ${util.inspect(os.loadavg())}</td></tr>
<tr><th>Pamięć</th><td>W sumie: ${os.totalmem()} Wolna: ${os.freemem()}</td></tr>
<tr><th>Procesory</th><td><pre>${util.inspect(os.cpus())}</pre></td></tr>
<tr><th>Sieć</th><td><pre>${util.inspect(os.networkInterfaces())}</pre></td></tr>
</table>
</body></html>`);
    } else {
        res.writeHead(404, {'Content-Type': 'text/plain'});
        res.end("Nieprawidłowy adres URL "+ req.url);
    }
});

server.listen(8124);
// require('../events/httpsniffer').sniffOn(server);
console.log('Oczekiwanie na żądania pod adresem http://localhost:8124');
