var http = require('http');
var url  = require('url');
var util = require('util');

var argUrl = process.argv[2];
var parsedUrl = url.parse(argUrl, true);

// Obiekt options jest przekazywany do wywołania http.request
// i określa docelowy adres URL
var options = {
  host: parsedUrl.hostname,
  port: parsedUrl.port,
  path: parsedUrl.pathname,
  method: 'GET'
};

if (parsedUrl.search) options.path += "?"+parsedUrl.search;

var req = http.request(options);
// Wywoływana po zakończeniu przetwarzania żądania
req.on('response', res => {
  util.log('STATUS: ' + res.statusCode);
  util.log('NAGŁÓWKI: ' + util.inspect(res.headers));
  res.setEncoding('utf8');
  res.on('data', chunk => { util.log('TREŚĆ: ' + chunk); });
  res.on('error', err => {  util.log('BŁĄD ODPOWIEDZI: ' + err); });
});
// Wywoływana w reakcji na błędy
req.on('error', err => { util.log('BŁĄD ŻĄDANIA: ' + err); });
req.end();
